<?php 
if (!defined('__TYPECHO_ROOT_DIR__')) {
	http_response_code(404);
	exit;
} 
?>
<?php $this->need('header.php'); ?>

<header class="py-12 md:py-16 px-4 bg-gradient-to-b from-white to-gray-50 border-b border-gray-200">
    <div class="max-w-6xl mx-auto">
        <h1 class="text-3xl md:text-4xl font-bold text-dark mb-4"><?php $this->title(); ?></h1>
        <div class="flex flex-wrap items-center text-gray-500 text-sm gap-4">
            <span><i class="fa fa-calendar-o mr-1"></i> <?php $this->date('Y-m-d'); ?></span>
            <span><i class="fa fa-eye mr-1"></i> <?php $this->viewsNum(); ?> 阅读</span>
            <span><i class="fa fa-comment-o mr-1"></i> <?php $this->commentsNum('0', '1', '%d'); ?> 评论</span>
        </div>
    </div>
</header>

<main class="max-w-6xl mx-auto px-4 py-8">
    <div class="flex flex-col lg:flex-row gap-8">
        <div class="lg:w-2/3">
            <article class="bg-white rounded-2xl shadow-nebulaui p-6 md:p-8 mb-8">
                <div class="prose max-w-none article-content">
                    <?php 
                    $content = $this->content;                    
                    $content = preg_replace_callback('/<pre><code(.*?)>(.*?)<\/code><\/pre>/s', function($matches) {
                        $attrs = $matches[1];
                        $code = htmlspecialchars_decode($matches[2]);
                        return '<div class="code-block-wrapper my-6"><pre class="hljs rounded-xl overflow-hidden border border-gray-200"><code' . $attrs . '>' . htmlspecialchars($code) . '</code></pre></div>';
                    }, $content);                    
                    $content = preg_replace_callback('/<img\s+([^>]+)>/i', function($matches) {
                        $attrs = $matches[1];
                        preg_match('/src=["\']([^"\']+)["\']/', $attrs, $srcMatch);
                        $src = $srcMatch[1] ?? '';
                        preg_match('/alt=["\']([^"\']+)["\']/', $attrs, $altMatch);
                        $alt = $altMatch[1] ?? '';
                        $attrs = preg_replace('/class=["\'][^"\']*["\']/', '', $attrs);
                        
                        return '<div class="image-wrapper my-6 overflow-hidden rounded-2xl shadow-nebulaui hover:shadow-nebulaui-hover transition-shadow duration-300">
                                    <a href="' . $src . '" class="glightbox" data-gallery="gallery1" data-title="' . htmlspecialchars($alt) . '">
                                        <img src="' . $src . '" alt="' . htmlspecialchars($alt) . '" class="w-full h-auto cursor-pointer transition-transform duration-500 hover:scale-105" loading="lazy" ' . $attrs . '>
                                    </a>
                                </div>';
                    }, $content);                    
                    $content = preg_replace_callback('/<video\s+([^>]+)>(.*?)<\/video>/s', function($matches) {
                        $attrs = $matches[1];
                        $content = $matches[2];
                        $attrs = preg_replace('/class=["\'][^"\']*["\']/', '', $attrs);
                        $videoClass = 'rounded-2xl overflow-hidden shadow-nebulaui w-full h-auto video-player';
                        
                        return '<div class="video-wrapper my-6 relative">
                                    <video class="' . $videoClass . '" controls preload="metadata" ' . $attrs . '>
                                        ' . $content . '
                                    </video>
                                </div>';
                    }, $content);
                    $content = preg_replace_callback('/<iframe\s+([^>]+)><\/iframe>/i', function($matches) {
                        $attrs = $matches[1];
                        $attrs = preg_replace('/class=["\'][^"\']*["\']/', '', $attrs);
                        
                        return '<div class="video-wrapper my-6 rounded-2xl overflow-hidden shadow-nebulaui">
                                    <div class="aspect-w-16 aspect-h-9">
                                        <iframe class="w-full h-full rounded-2xl" ' . $attrs . ' loading="lazy"></iframe>
                                    </div>
                                </div>';
                    }, $content);
                    echo $content;
                    ?>
                </div>
                
                <div class="mt-10 pt-6 border-t border-gray-200 text-center">
                    <span class="text-primary font-semibold text-lg">------ 本页内容已结束，喜欢请分享 ------</span>
                </div>
           
                <div class="mt-8">
                    <a href="<?php $this->options->siteUrl(); ?>" title="更多精彩文章，请关注本站">
                        <img style="display: block; width: 100%; height: auto; border-radius: 12px;" 
                             src="<?php $this->options->themeUrl('/assets/img/6561c98c703bf.gif'); ?>" 
                             alt="本站推广" 
                             onerror="this.src='data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNTAwIiBoZWlnaHQ9IjIwMCIgdmlld0JveD0iMCAwIDUwMCAyMDAiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3Qgd2lkdGg9IjUwMCIgaGVpZ2h0PSIyMDAiIHJ4PSIxMiIgZmlsbD0iIzRGNjBFNSIvPjx0ZXh0IHg9IjI1MCIgeT0iMTAwIiBmb250LWZhbWlseT0iQXJpYWwiIGZvbnQtc2l6ZT0iMjQiIGZpbGw9IndoaXRlIiB0ZXh0LWFuY2hvcj0ibWlkZGxlIiBkeT0iLjNlbSI+5bCE6K+V5paH56ugPC90ZXh0Pjwvc3ZnPg=='">
                    </a>
                </div>
            </article>

            <?php if ($this->tags): ?>
            <div class="bg-white rounded-2xl shadow-nebulaui p-6 mb-8">
                <div class="flex flex-wrap items-center gap-2">
                    <span class="text-sm text-gray-500 mr-2"><i class="fa fa-tags mr-1"></i> 标签：</span>
                    <?php 
                    $this->tags(' ', true, '<a href="{permalink}" class="px-3 py-1.5 text-sm bg-gray-100 text-gray-700 rounded-full hover:bg-primary hover:text-white transition-colors mr-2 mb-2 inline-flex items-center">{name}</a>');
                    ?>
                </div>
            </div>
            <?php endif; ?>

            <div class="bg-white rounded-2xl shadow-nebulaui p-6 mb-8 card-hover">
                <h3 class="text-lg font-semibold mb-4 text-primary flex items-center">
                    <i class="fa fa-exclamation-triangle mr-2"></i> 免责声明
                </h3>
                <div class="text-sm text-gray-600 space-y-3">
                    <p><strong>一、内容声明</strong><br>本站所有文章内容均为个人学习、研究和经验分享，仅供参考，不构成任何专业建议或承诺。读者应自行判断内容真实性，并承担使用风险。</p>
                    <p><strong>二、版权声明</strong><br>本站文章采用 <a href="https://creativecommons.org/licenses/by-nc-sa/4.0/" target="_blank" class="text-primary hover:underline">CC BY-NC-SA 4.0</a> 协议进行许可。转载需注明出处，不得用于商业用途。</p>
                    <p><strong>三、免责条款</strong><br>对于因使用本站内容而产生的任何直接、间接损失，本站及作者不承担任何责任。技术操作有风险，请在专业人士指导下进行。</p>
                    <p><strong>四、联系方式</strong><br>如发现侵权内容或存在问题，请通过网站联系方式及时反馈，我们将在核实后第一时间处理。</p>
                </div>
                
                <div class="mt-6 pt-4 border-t border-gray-100">
                    <div class="flex flex-wrap gap-4 text-xs text-gray-500">
                        <div class="flex items-center">
                            <i class="fa fa-user mr-1"></i>
                            <span>作者：<?php echo Helper::options()->nickname ?: '本站作者'; ?></span>
                        </div>
                        <div class="flex items-center">
                            <i class="fa fa-link mr-1"></i>
                            <span>原文：<a href="<?php $this->permalink(); ?>" class="hover:text-primary"><?php $this->title(); ?></a></span>
                        </div>
                        <div class="flex items-center">
                            <i class="fa fa-calendar mr-1"></i>
                            <span>发布于：<?php $this->date('Y-m-d'); ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="lg:w-1/3 space-y-6">
            <div class="bg-white rounded-2xl shadow-nebulaui p-6 card-hover">
                <div class="flex items-center mb-4">
                    <img src="<?php echo getAvatar(); ?>" alt="作者头像" 
                        class="w-16 h-16 rounded-full mr-4 border-2 border-primary/20">
                    <div>
                        <h3 class="font-semibold text-lg"><?php echo Helper::options()->nickname ?: '作者'; ?></h3>
                        <p class="text-sm text-gray-500"><?php echo Helper::options()->description ?: '技术分享者'; ?></p>
                    </div>
                </div>
                <p class="text-sm text-gray-600 mb-4">
                    <?php echo Helper::options()->bio ?: '热爱技术，乐于分享。专注于Web开发、前后端技术等领域。'; ?>
                </p>
                
                <div class="space-y-2 text-sm">
                    <div class="flex items-center text-gray-500">
                        <i class="fa fa-envelope mr-2 w-4"></i>
                        <span>联系邮箱：<?php echo Helper::options()->adminEmail ?: '未设置'; ?></span>
                    </div>
                    <?php if (Helper::options()->github): ?>
                    <div class="flex items-center text-gray-500">
                        <i class="fa fa-github mr-2 w-4"></i>
                        <span>GitHub：<a href="https://<?php echo Helper::options()->github; ?>" target="_blank" class="text-primary hover:underline"><?php echo Helper::options()->github; ?></a></span>
                    </div>
                    <?php endif; ?>
                    <?php if (Helper::options()->siteUrl): ?>
                    <div class="flex items-center text-gray-500">
                        <i class="fa fa-globe mr-2 w-4"></i>
                        <span>网站：<a href="<?php $this->options->siteUrl(); ?>" target="_blank" class="text-primary hover:underline"><?php echo parse_url($this->options->siteUrl(), PHP_URL_HOST); ?></a></span>
                    </div>
                    <?php endif; ?>
                </div>
                
                <div class="mt-6 pt-4 border-t border-gray-100">
    <h4 class="text-sm font-semibold mb-3 text-gray-700">最近文章</h4>
    <?php 
    $recentPosts = getLatestArticlesWithLinks(4, '我的项目');
    
    if ($recentPosts && count($recentPosts) > 0): 
    ?>
    <div class="space-y-2">
        <?php foreach ($recentPosts as $post): ?>
        <a href="<?php echo $post['permalink']; ?>" 
           class="block p-2 rounded-lg hover:bg-gray-50 transition-colors group">
            <div class="flex justify-between items-center">
                <h5 class="text-sm font-medium text-gray-700 group-hover:text-primary truncate max-w-[70%]">
                    <?php echo htmlspecialchars($post['title']); ?>
                </h5>
                <span class="text-xs text-gray-400">
                    <?php echo date('m-d', $post['created']); ?>
                </span>
            </div>
        </a>
        <?php endforeach; ?>
    </div>
    <?php else: ?>
    <p class="text-sm text-gray-400 text-center py-2">暂无文章</p>
    <?php endif; ?>
</div>
            </div>

            <div class="bg-white rounded-2xl shadow-nebulaui p-6">
                <h3 class="text-xl font-semibold mb-4 flex items-center">
                    <i class="fa fa-comments mr-2 text-primary"></i> 评论
                    <span class="ml-2 text-sm bg-primary text-white px-2 py-0.5 rounded-full">
                        <?php $this->commentsNum('0', '1', '%d'); ?>
                    </span>
                </h3>
                <?php $this->need('comments.php'); ?>
            </div>
        </div>
    </div>
</main>

<?php $this->need('footer.php'); ?>