<?php
/**
 * JueAi Ui个人主页
 *
 * @package JueAiUi
 * @author 尘苍
 * @version 1.0.4
 * @link https://www.jueai.chat
 */
 if (!defined('__TYPECHO_ROOT_DIR__')) {
	http_response_code(404);
	exit;
}
$this->need('header.php');
?>

<section class="py-16 md:py-24 px-4 bg-gradient-to-b from-white to-gray-50">
    <div class="max-w-7xl mx-auto flex flex-col md:flex-row items-center">
        <div class="relative mb-8 md:mb-0">
            <img src="<?php echo getAvatar(); ?>" alt="头像" 
                class="w-48 h-48 md:w-64 md:h-64 rounded-full border-4 border-white shadow-nebulaui object-cover">
            <div class="absolute bottom-0 right-0 bg-primary text-white text-xs font-bold px-2 py-1 rounded-full shadow-md">
                在线
            </div>
        </div>
        <div class="md:ml-12 text-center md:text-left">
            <h1 class="text-[clamp(2rem,5vw,3.5rem)] font-bold text-dark leading-tight">
                你好，我是 <span class="text-primary"><?php echo Helper::options()->nickname; ?></span>
            </h1>
            <p class="mt-4 text-lg text-gray-600 max-w-xl">
                <?php echo Helper::options()->description; ?>
            </p>
            <div class="mt-8 flex flex-wrap justify-center md:justify-start gap-4">
                <a href="#contact" class="bg-primary hover:bg-primary/90 text-white px-6 py-3 rounded-full transition-colors flex items-center shadow-lg">
                    <i class="fa fa-handshake-o mr-2"></i> 合作洽谈
                </a>
                <a href="#projects" class="bg-white hover:bg-gray-100 text-dark border border-gray-200 px-6 py-3 rounded-full transition-colors flex items-center shadow">
                    <i class="fa fa-code mr-2"></i> 查看作品
                </a>
            </div>
        </div>
    </div>
</section>

<main class="max-w-7xl mx-auto px-4 py-12">
    <section id="about" class="mb-20">
        <div class="text-center mb-12">
            <h2 class="text-3xl font-bold text-dark"><?php echo Helper::options()->about; ?></h2>
            <div class="w-20 h-1 bg-primary rounded-full mx-auto mt-4"></div>
        </div>

        <div class="bg-white rounded-2xl shadow-nebulaui p-6 md:p-8 card-hover">
            <div class="grid md:grid-cols-2 gap-8 items-center">
                <div>
                    <h3 class="text-xl font-semibold mb-4"><?php echo Helper::options()->introduce; ?></h3>
                    <p class="text-gray-600 mb-4">
                        <?php echo Helper::options()->bio; ?>
                    </p>
                    
                    <div class="mt-6 grid grid-cols-2 gap-4">
                        <div class="text-center">
                            <div class="text-3xl font-bold text-primary num" 
                                data-target="<?php echo Helper::options()->expYears ?: 5; ?>">0</div>
                            <div class="text-sm text-gray-500"><?php echo Helper::options()->expText; ?></div>
                        </div>
                        <div class="text-center">
                            <div class="text-3xl font-bold text-primary num" 
                                data-target="<?php echo Helper::options()->projectsCount ?: 20; ?>">0</div>
                            <div class="text-sm text-gray-500"><?php echo Helper::options()->projectsText; ?></div>
                        </div>
                        <div class="text-center">
                            <div class="text-3xl font-bold text-primary num" 
                                data-target="<?php echo Helper::options()->skillsCount ?: 10; ?>">0</div>
                            <div class="text-sm text-gray-500"><?php echo Helper::options()->skillsText; ?></div>
                        </div>
                        <div class="text-center">
                            <div class="text-3xl font-bold text-primary num" 
                                data-target="<?php echo Helper::options()->commitsCount ?: 5000; ?>">0</div>
                            <div class="text-sm text-gray-500"><?php echo Helper::options()->commitsText; ?></div>
                        </div>
                    </div>
                </div>
                
                <div class="bg-gray-50 rounded-2xl p-6 border border-gray-200">
                    <h3 class="text-xl font-semibold mb-4"><?php echo Helper::options()->achievement; ?></h3>
                    <div class="space-y-4">
                        <?php 
                        $achievements = getAchievements();
                        $colors = array('yellow', 'blue', 'green');
                        $colorClasses = array(
                            'yellow' => 'bg-yellow-100 text-yellow-500',
                            'blue' => 'bg-blue-100 text-blue-500',
                            'green' => 'bg-green-100 text-green-500'
                        );
                        
                        if (!empty($achievements)) {
                            foreach ($achievements as $index => $achievement) {
                                $color = $colors[$index % count($colors)];
                                $colorClass = $colorClasses[$color];
                        ?>
                        <div class="flex items-center">
                            <div class="w-12 h-12 <?php echo $colorClass; ?> rounded-full flex items-center justify-center mr-4">
                                <i class="fa <?php echo $achievement['icon']; ?> text-xl"></i>
                            </div>
                            <div>
                                <h4 class="font-medium"><?php echo $achievement['title']; ?></h4>
                                <p class="text-sm text-gray-500"><?php echo $achievement['desc']; ?></p>
                            </div>
                        </div>
                        <?php 
                            }
                        } else {
                        ?>
                        <div class="text-center text-gray-500 py-4">
                            暂无成就，请在主题设置中添加
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

<section id="skills" class="mb-20">
    <div class="text-center mb-12">
        <h2 class="text-3xl font-bold text-dark"><?php echo Helper::options()->SkillTitle; ?></h2>
        <div class="w-20 h-1 bg-primary rounded-full mx-auto mt-4"></div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        <?php 
        $skills = getSkills();
        $skillColors = array(
            array('bg' => 'blue-100', 'text' => 'blue-500', 'bar' => 'blue-500'),
            array('bg' => 'purple-100', 'text' => 'purple-500', 'bar' => 'purple-500'),
            array('bg' => 'green-100', 'text' => 'green-500', 'bar' => 'green-500'),
            array('bg' => 'red-100', 'text' => 'red-500', 'bar' => 'red-500'),
            array('bg' => 'orange-100', 'text' => 'orange-500', 'bar' => 'orange-500'),
            array('bg' => 'pink-100', 'text' => 'pink-500', 'bar' => 'pink-500')
        );
        
        if (!empty($skills)) {
            foreach ($skills as $index => $skill) {
                $color = $skillColors[$index % count($skillColors)];
        ?>
        <div class="bg-white rounded-2xl p-6 shadow-nebulaui card-hover">
            <div class="w-14 h-14 bg-<?php echo $color['bg']; ?> rounded-2xl flex items-center justify-center text-<?php echo $color['text']; ?> mb-4">
                <i class="fa <?php echo $skill['icon']; ?> text-2xl"></i>
            </div>
            <h3 class="text-xl font-semibold mb-2"><?php echo $skill['title']; ?></h3>
            <p class="text-gray-600 mb-4"><?php echo $skill['desc']; ?></p>
            <div class="space-y-2">
                <?php if ($skill['name1'] && $skill['rate1']): ?>
                <div>
                    <div class="flex justify-between text-sm mb-1">
                        <span><?php echo $skill['name1']; ?></span>
                        <span class="skill-percent-wrapper whitespace-nowrap">
                            <span class="num" data-target="<?php echo $skill['rate1']; ?>">0</span>
                            <span class="percent-sign">%</span>
                        </span>
                    </div>
                    <div class="w-full bg-gray-200 rounded-full h-2">
                        <div class="bg-<?php echo $color['bar']; ?> h-2 rounded-full" style="width: <?php echo $skill['rate1']; ?>%"></div>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if ($skill['name2'] && $skill['rate2']): ?>
                <div>
                    <div class="flex justify-between text-sm mb-1">
                        <span><?php echo $skill['name2']; ?></span>
                        <span class="skill-percent-wrapper whitespace-nowrap">
                            <span class="num" data-target="<?php echo $skill['rate2']; ?>">0</span>
                            <span class="percent-sign">%</span>
                        </span>
                    </div>
                    <div class="w-full bg-gray-200 rounded-full h-2">
                        <div class="bg-<?php echo $color['bar']; ?> h-2 rounded-full" style="width: <?php echo $skill['rate2']; ?>%"></div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <?php 
            }
        } else {
        ?>
        <div class="col-span-3 text-center py-12">
            <p class="text-gray-500">暂无<?php echo Helper::options()->SkillTitle; ?>，请在主题设置中添加<?php echo Helper::options()->SkillTitle; ?>信息</p>
        </div>
        <?php } ?>
    </div>
</section>

<section id="projects" class="mb-20">
    <div class="text-center mb-12">
        <h2 class="text-3xl font-bold text-dark"><?php echo Helper::options()->ProjectTitle; ?></h2>
        <div class="w-20 h-1 bg-primary rounded-full mx-auto mt-4"></div>
    </div>

    <?php 
    $projects = getProjectsWithLinks();
    
    if ($projects): 
    ?>
    <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
        <?php foreach ($projects as $project): 
            $tags = getPostTags($project['cid']);
            $thumbnail = getProjectThumbnail($project['text'], $project['cid']);
            $summary = getPostExcerpt($project['text'], 100);
        ?>
        <div class="bg-white rounded-2xl overflow-hidden shadow-nebulaui card-hover">
            <div class="h-48 bg-gradient-to-r from-blue-500 to-purple-600 flex items-center justify-center relative overflow-hidden">
                <?php if ($thumbnail): ?>
                    <img src="<?php echo $thumbnail; ?>" 
                         alt="<?php echo htmlspecialchars($project['title']); ?>" 
                         class="w-full h-full object-cover">
                    <span class="absolute text-white font-bold text-xl bg-black/30 px-4 py-2 rounded-full">
                        <?php echo htmlspecialchars($project['title']); ?>
                    </span>
                <?php else: ?>
                    <div class="relative w-full h-full flex items-center justify-center">
                        <i class="fa fa-laptop text-white text-6xl opacity-50"></i>
                        <span class="absolute text-white font-bold text-xl">
                            <?php echo htmlspecialchars($project['title']); ?>
                        </span>
                    </div>
                <?php endif; ?>
            </div>
            <div class="p-6">
                <h3 class="text-xl font-semibold mb-2"><?php echo htmlspecialchars($project['title']); ?></h3>
                <p class="text-gray-600 mb-4"><?php echo htmlspecialchars($summary); ?></p>
                <div class="flex justify-between items-center">
                    <?php if ($tags): ?>
                    <div class="flex space-x-2">
                        <?php 
                        $tagColors = array('blue', 'gray', 'green', 'purple', 'yellow', 'red');
                        foreach ($tags as $tagIndex => $tag) {
                            $color = $tagColors[$tagIndex % count($tagColors)];
                        ?>
                        <span class="bg-<?php echo $color; ?>-100 text-<?php echo $color; ?>-800 text-xs px-2 py-1 rounded-full">
                            <?php echo htmlspecialchars($tag['name']); ?>
                        </span>
                        <?php } ?>
                    </div>
                    <?php endif; ?>
                    <a href="<?php echo $project['permalink']; ?>" 
                        class="text-primary hover:text-primary/80 font-medium flex items-center">
                        查看详情 <i class="fa fa-arrow-right ml-1"></i>
                    </a>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
    <?php else: ?>
    <div class="text-center py-12">
        <?php if ($this->user->hasLogin()): ?>
            <p class="text-gray-500">暂无项目，请先在后台创建"我的项目"分类并发布文章</p>
            <a href="<?php echo Typecho_Common::url('write-post.php', Helper::options()->adminUrl); ?>" 
                class="inline-block mt-4 bg-primary hover:bg-primary/90 text-white px-6 py-2 rounded-lg">
                创建项目
            </a>
        <?php else: ?>
            <p class="text-gray-500">暂无项目</p>
        <?php endif; ?>
    </div>
    <?php endif; ?>
</section>

<section id="articles" class="mb-20">
    <div class="text-center mb-12">
        <h2 class="text-3xl font-bold text-dark"><?php echo Helper::options()->articleTitle; ?></h2>
        <div class="w-20 h-1 bg-primary rounded-full mx-auto mt-4"></div>
    </div>

    <div class="bg-white rounded-2xl shadow-nebulaui p-6 md:p-8 card-hover">
        <?php 
        $recentPosts = getLatestArticlesWithLinks(12, '我的项目');
        
        if ($recentPosts && count($recentPosts) > 0): 
        ?>
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 mb-8">
            <?php foreach ($recentPosts as $post): ?>
            <a href="<?php echo $post['permalink']; ?>" 
                class="p-4 border border-gray-100 rounded-xl hover:bg-gray-50 transition-colors block">
                <div class="flex justify-between items-center">
                    <h3 class="text-base font-medium text-gray-800 hover:text-primary transition-colors truncate max-w-[70%]">
                        <?php echo htmlspecialchars($post['title']); ?>
                    </h3>
                    <span class="text-xs text-gray-500 flex items-center whitespace-nowrap">
                        <i class="fa fa-calendar-o mr-1"></i> 
                        <?php echo date('Y-m-d', $post['created']); ?>
                    </span>
                </div>
            </a>
            <?php endforeach; ?>
        </div>
        <?php else: ?>
        <div class="text-center py-8">
            <p class="text-gray-500">暂无文章</p>
        </div>
        <?php endif; ?>        
        <?php if ($this->user->hasLogin()): ?>
        <div class="text-center">
            <a href="<?php echo Typecho_Common::url('write-post.php', Helper::options()->adminUrl); ?>" 
                class="inline-flex items-center bg-primary hover:bg-primary/90 text-white px-4 py-2 rounded-lg transition-colors">
                <i class="fa fa-edit mr-2"></i> 写文章
            </a>
        </div>
        <?php endif; ?>
    </div>
</section>

<section id="websites" class="mb-20">
    <div class="text-center mb-12">
        <h2 class="text-3xl font-bold text-dark"><?php echo Helper::options()->links; ?></h2>
        <div class="w-20 h-1 bg-primary rounded-full mx-auto mt-4"></div>
    </div>

    <div class="bg-white rounded-2xl shadow-nebulaui p-6 md:p-8 card-hover">
        <h3 class="text-xl font-semibold mb-6">网站列表</h3>
        <div class="space-y-4" id="websiteList">
            <?php 
            $websites = getWebsites();
            
            if (!empty($websites)) {
                $websiteColors = array('red', 'yellow', 'blue', 'green', 'purple');
                
                foreach ($websites as $index => $website) {
                    $color = $websiteColors[$index % count($websiteColors)];
                    $isImage = isset($website['type']) && $website['type'] === 'image';
                    $iconClass = $isImage ? '' : $website['icon'];
            ?>
            <a href="<?php echo $website['url']; ?>" target="_blank" 
                class="website-item flex items-center p-3 border border-gray-100 rounded-xl hover:bg-gray-50 transition-colors" 
                data-url="<?php echo $website['url']; ?>">
                <div class="w-10 h-10 bg-<?php echo $color; ?>-100 rounded-full flex items-center justify-center text-<?php echo $color; ?>-500 mr-3 overflow-hidden">
                    <?php if ($isImage && isset($website['icon'])): ?>
                        <img src="<?php echo $website['icon']; ?>" alt="<?php echo $website['name']; ?>" class="w-full h-full object-cover">
                    <?php else: ?>
                        <i class="fa <?php echo $iconClass; ?>"></i>
                    <?php endif; ?>
                </div>
                <div class="flex-1 min-w-0">
                    <h4 class="font-medium truncate"><?php echo $website['name']; ?></h4>
                    <p class="text-sm text-gray-500 truncate"><?php echo $website['url']; ?></p>
                </div>
                <span class="text-sm font-medium px-2 py-1 rounded-full bg-gray-100 text-gray-600 status-badge">
                    未检测
                </span>
            </a>
            <?php 
                }
            } else {
            ?>
            <div class="text-center py-6">
                <p class="text-gray-500">暂无网站，请在主题设置中添加</p>
            </div>
            <?php } ?>
        </div>
    </div>
</section>

    <?php if (Helper::options()->enableFunTools): ?>
<section id="fun" class="mb-20">
    <div class="text-center mb-12">
        <h2 class="text-3xl font-bold text-dark">娱乐小工具</h2>
        <div class="w-20 h-1 bg-primary rounded-full mx-auto mt-4"></div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
        <div class="space-y-8">
            <div class="bg-white rounded-2xl p-6 shadow-nebulaui card-hover">
                <div class="w-14 h-14 bg-yellow-100 rounded-2xl flex items-center justify-center text-yellow-500 mb-4">
                    <i class="fa fa-coffee text-2xl"></i>
                </div>
                <h3 class="text-xl font-semibold mb-2">摸鱼计算器</h3>
                <p class="text-gray-600 mb-4">计算你已经摸鱼了多久。</p>
                <div class="bg-gray-50 rounded-lg p-4 mb-4">
                    <div class="flex justify-between items-center mb-2">
                        <span class="text-sm">当前时间</span>
                        <span class="font-medium" id="currentTime">14:30:00</span>
                    </div>
                    <div class="flex justify-between items-center mb-2">
                        <span class="text-sm">摸鱼开始时间</span>
                        <span class="font-medium" id="startFishTime">--:--:--</span>
                    </div>
                    <div class="border-t border-gray-200 my-3 pt-3">
                        <span class="text-sm">已经摸鱼</span>
                        <span class="font-bold text-xl text-primary ml-2" id="fishTime">0h 0m 0s</span>
                    </div>
                </div>
                <button id="startFishBtn" class="w-full bg-yellow-400 hover:bg-yellow-500 text-white py-2 rounded-lg transition-colors text-sm">
                    开始摸鱼
                </button>
            </div>

            <div class="bg-white rounded-2xl p-6 shadow-nebulaui card-hover">
                <div class="w-14 h-14 bg-blue-100 rounded-2xl flex items-center justify-center text-blue-500 mb-4">
                    <i class="fa fa-tachometer text-2xl"></i>
                </div>
                <h3 class="text-xl font-semibold mb-3">网络测速</h3>
                <div class="bg-gray-50 rounded-lg p-4 mb-4">
                    <div class="text-center mb-3">
                        <div class="text-4xl font-bold text-primary" id="speedResult">--</div>
                        <div class="text-sm text-gray-500">Ping (ms)</div>
                    </div>
                    <div class="h-4 w-full bg-gray-200 rounded-full overflow-hidden mb-3">
                        <div class="h-full bg-primary rounded-full transition-all duration-1000" id="speedBar" style="width: 0%"></div>
                    </div>
                    <div class="flex justify-between text-sm text-gray-500 mb-4">
                        <span>0 ms</span>
                        <span>500 ms</span>
                        <span>1000+ ms</span>
                    </div>
                    <button id="testBtn" class="w-full bg-primary hover:bg-primary/90 text-white py-2 rounded-lg transition-colors flex items-center justify-center">
                        <i class="fa fa-refresh mr-2"></i> 开始测速
                    </button>
                </div>
            </div>
        </div>

        <div class="space-y-8">
            <div class="bg-white rounded-2xl p-6 shadow-nebulaui card-hover">
                <div class="w-14 h-14 bg-pink-100 rounded-2xl flex items-center justify-center text-pink-500 mb-4">
                    <i class="fa fa-quote-right text-2xl"></i>
                </div>
                <h3 class="text-xl font-semibold mb-2">随机一言</h3>
                <div class="bg-gray-50 rounded-lg p-4 mb-4 min-h-[100px] flex items-center" id="hitokoto">
                    正在加载一言...
                </div>
                <button id="refreshHitokoto" class="w-full bg-pink-500 hover:bg-pink-600 text-white py-2 rounded-lg transition-colors flex items-center justify-center">
                    <i class="fa fa-refresh mr-2"></i> 换一句
                </button>
            </div>

            <?php if (Helper::options()->musicUrl): ?>
<div class="bg-white rounded-2xl p-6 shadow-nebulaui card-hover">
    <div class="w-14 h-14 bg-purple-100 rounded-2xl flex items-center justify-center text-purple-500 mb-4">
        <i class="fa fa-music text-2xl"></i>
    </div>
    <h3 class="text-xl font-semibold mb-3">在线音乐播放</h3>
    <div class="bg-gray-50 rounded-lg p-4 mb-4">
        <div class="text-center mb-3" id="nowPlaying">未播放</div>
        <div class="mb-3">
            <div class="flex justify-between text-xs text-gray-500 mb-1">
                <span id="musicCurrentTime">00:00</span>
                <span id="musicDuration">00:00</span>
            </div>
            <div class="relative">
                <div class="w-full h-2 bg-gray-200 rounded-full overflow-hidden">
                    <div id="progressBar" class="absolute h-full bg-primary rounded-full transition-all duration-300" style="width: 0%"></div>
                </div>
                <input type="range" id="progressSlider" min="0" max="100" value="0" 
                    class="absolute top-0 left-0 w-full h-2 opacity-0 cursor-pointer"
                   oninput="seekAudio(this.value)">
            </div>
        </div>
        <div class="flex gap-2">
            <button id="playMusic" 
                class="flex-1 bg-primary hover:bg-primary/90 text-white py-2 rounded-lg transition-colors flex items-center justify-center">
                <i class="fa play-icon fa-play mr-2"></i> 播放/暂停
            </button>        
        </div>
    </div>
</div>
<?php endif; ?>
        </div>
    </div>
</section>
<?php endif; ?>

    <?php if (Helper::options()->wechatQr || Helper::options()->alipayQr || Helper::options()->qqPayQr): ?>
    <section id="sponsor" class="mb-20">
        <div class="text-center mb-12">
            <h2 class="text-3xl font-bold text-dark">赞助我</h2>
            <div class="w-20 h-1 bg-primary rounded-full mx-auto mt-4"></div>
        </div>

        <div class="bg-white rounded-2xl shadow-nebulaui p-6 md:p-8 card-hover">
            <div class="text-center mb-8">
                <p class="text-gray-600 max-w-2xl mx-auto">
                    如果我的项目或文章对你有帮助，欢迎通过以下方式进行赞助，你的支持是我持续更新的动力～
                </p>
            </div>

            <div class="flex flex-col md:flex-row justify-center gap-6">
                <?php if (Helper::options()->qqPayQr): ?>
                <button class="sponsor-btn w-full md:w-48 p-4 border border-gray-200 rounded-xl hover:border-primary hover:bg-primary/5 transition-colors flex flex-col items-center justify-center" data-type="qq">
                    <div class="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center text-blue-500 mb-2">
                        <i class="fa fa-qq text-2xl"></i>
                    </div>
                    <span class="font-medium">QQ 收款码</span>
                </button>
                <?php endif; ?>
                
                <?php if (Helper::options()->wechatQr): ?>
                <button class="sponsor-btn w-full md:w-48 p-4 border border-gray-200 rounded-xl hover:border-primary hover:bg-primary/5 transition-colors flex flex-col items-center justify-center" data-type="wechat">
                    <div class="w-12 h-12 bg-green-100 rounded-full flex items-center justify-center text-green-500 mb-2">
                        <i class="fa fa-weixin text-2xl"></i>
                    </div>
                    <span class="font-medium">微信收款码</span>
                </button>
                <?php endif; ?>
                
                <?php if (Helper::options()->alipayQr): ?>
                <button class="sponsor-btn w-full md:w-48 p-4 border border-gray-200 rounded-xl hover:border-primary hover:bg-primary/5 transition-colors flex flex-col items-center justify-center" data-type="alipay">
                    <div class="w-12 h-12 bg-blue-500 rounded-full flex items-center justify-center text-white mb-2">
                        <i class="fa fa-alipay fa-2x"></i>
                    </div>
                    <span class="font-medium">支付宝收款码</span>
                </button>
                <?php endif; ?>
            </div>
        </div>
    </section>
    <?php endif; ?>

<section id="contact" class="mb-12">
    <div class="text-center mb-12">
        <h2 class="text-3xl font-bold text-dark">联系我</h2>
        <div class="w-20 h-1 bg-primary rounded-full mx-auto mt-4"></div>
    </div>

    <div class="bg-white rounded-2xl shadow-nebulaui p-6 md:p-8 card-hover">
        <?php 
        $contacts = getContacts();
        $contactColors = array(
            'email' => 'blue',
            'qq' => 'green',
            'wechat' => 'green',
            'github' => 'purple',
            'phone' => 'orange',
            'location' => 'red',
            'website' => 'indigo'
        );
        
        if (!empty($contacts)): 
        ?>
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4">
            <?php 
            foreach ($contacts as $contact) {
                $color = isset($contactColors[$contact['type']]) ? $contactColors[$contact['type']] : 'gray';
                $link = getContactLink($contact);
                $onclick = ($contact['action'] === 'copy') ? "onclick=\"" . getCopyScript($contact['value']) . " return false;\"" : "";
            ?>
            <a href="<?php echo $link; ?>" <?php echo $onclick; ?> 
               class="contact-item p-4 border border-gray-100 rounded-xl hover:bg-gray-50 transition-colors block <?php echo $contact['action'] === 'copy' ? 'cursor-pointer' : ''; ?>">
                <div class="flex items-center mb-2">
                    <div class="w-10 h-10 bg-<?php echo $color; ?>-100 rounded-full flex items-center justify-center text-<?php echo $color; ?>-500 mr-3">
                        <i class="fa <?php echo $contact['icon']; ?>"></i>
                    </div>
                    <h3 class="font-medium text-gray-800"><?php echo $contact['label']; ?></h3>
                </div>
                <p class="text-sm text-gray-600 truncate"><?php echo $contact['value']; ?></p>
                <?php if ($contact['action'] === 'copy'): ?>
                <div class="mt-2">
                    <span class="text-xs bg-gray-100 text-gray-600 px-2 py-1 rounded">点击复制</span>
                </div>
                <?php endif; ?>
            </a>
            <?php } ?>
        </div>
        <?php else: ?>
        <div class="text-center py-8">
            <p class="text-gray-500">暂无联系方式，请在主题设置中添加</p>
        </div>
        <?php endif; ?>
        
        <?php if ($this->user->hasLogin()): ?>
        <div class="text-center mt-8">
            <a href="<?php echo Typecho_Common::url('admin/profile.php', Helper::options()->adminUrl); ?>" 
                class="inline-flex items-center bg-primary hover:bg-primary/90 text-white px-4 py-2 rounded-lg transition-colors">
                <i class="fa fa-cog mr-2"></i> 管理联系方式
            </a>
        </div>
        <?php endif; ?>
    </div>
</section>
</main>
<?php $this->need('footer.php'); ?>