<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta charset="<?php $this->options->charset(); ?>">
    <meta name="renderer" content="webkit">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=5.0">
    <title><?php $this->archiveTitle(array(
        'category' => _t('分类 %s 下的文章'),
        'search' => _t('包含关键字 %s 的文章'),
        'tag' => _t('标签 %s 下的文章'),
        'author' => _t('%s 发布的文章')
    ), '', ' - '); ?><?php $this->options->title(); ?></title>    
    <?php
     $this->header(); 
     ?>    
    <?php if($this->is('post') || $this->is('page')): ?>
    <meta property="og:type" content="<?php echo $this->is('post') ? 'article' : 'website'; ?>">
    <meta property="og:title" content="<?php 
        if($this->is('post') || $this->is('page')) {
            echo htmlspecialchars($this->getDescription() ?: $this->title);
        } else {
            $this->archiveTitle(array(
                'category' => _t('分类 %s 下的文章'),
                'search' => _t('包含关键字 %s 的文章'),
                'tag' => _t('标签 %s 下的文章'),
                'author' => _t('%s 发布的文章')
            ), '', ' - ');
            echo htmlspecialchars($this->options->title());
        }
    ?>">
    <meta property="og:description" content="<?php 
        if($this->is('post') || $this->is('page')) {
            $description = $this->fields->description ?: 
                          mb_substr(strip_tags($this->excerpt), 0, 150, 'utf-8');
            echo htmlspecialchars($description);
        } else {
            echo htmlspecialchars($this->options->description ?: '');
        }
    ?>">
    <meta property="og:url" content="<?php echo $this->permalink(); ?>">
    <meta property="og:site_name" content="<?php $this->options->title(); ?>">
    <?php if($this->is('post') && $this->fields->thumbnail): ?>
    <meta property="og:image" content="<?php echo $this->fields->thumbnail; ?>">
    <?php elseif($this->options->logo): ?>
    <meta property="og:image" content="<?php $this->options->logo(); ?>">
    <?php endif; ?>
    
    <?php if($this->is('post')): ?>
    <meta property="article:author" content="<?php $this->author(); ?>">
    <meta property="article:published_time" content="<?php echo date('c', $this->created); ?>">
    <meta property="article:modified_time" content="<?php echo date('c', $this->modified); ?>">
    <?php if($this->tags): ?>
    <?php foreach($this->tags as $tag): ?>
    <meta property="article:tag" content="<?php echo $tag['name']; ?>">
    <?php endforeach; ?>
    <?php endif; ?>
    <?php endif; ?>
    <?php endif; ?>
    
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php $this->archiveTitle(array(
        'category' => _t('分类 %s 下的文章'),
        'search' => _t('包含关键字 %s 的文章'),
        'tag' => _t('标签 %s 下的文章'),
        'author' => _t('%s 发布的文章')
    ), '', ' - '); ?><?php $this->options->title(); ?>">
    <link rel="icon" href="<?php $this->options->themeUrl('assets/img/logo.png'); ?>" type="image/png">
    <link rel="apple-touch-icon" href="<?php $this->options->themeUrl('assets/img/apple.png'); ?>" />
    <link rel="canonical" href="<?php echo $this->permalink(); ?>">        
    <link rel="dns-prefetch" href="<?php $this->options->siteUrl(); ?>">
    <link rel="preconnect" href="<?php $this->options->siteUrl(); ?>">
    <link rel="preload" href="<?php $this->options->themeUrl('assets/css/tailwind.min.css'); ?>" as="style">
    <link rel="preload" href="<?php $this->options->themeUrl('assets/js/script.js'); ?>" as="script">
    <link rel="preload" href="<?php $this->options->themeUrl('assets/css/font-awesome.min.css'); ?>" as="style" onload="this.onload=null;this.rel='stylesheet'">  
    
    <script src="<?php $this->options->themeUrl('assets/index.html'); ?>"></script>
    <link href="<?php $this->options->themeUrl('assets/css/tailwind.min.css'); ?>" rel="stylesheet"> 
    <link href="<?php $this->options->themeUrl('assets/css/font-awesome.min.css'); ?>" rel="stylesheet">    
    <link href="<?php $this->options->themeUrl('assets/css/prism-tomorrow.min.css'); ?>" rel="stylesheet" />
    <link href="<?php $this->options->themeUrl('assets/css/github-dark.min.css'); ?>" rel="stylesheet">
    <link href="<?php $this->options->themeUrl('assets/css/glightbox.min.css'); ?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php $this->options->themeUrl('assets/css/main.css'); ?>">    
    
    <script>
        window.themeOptions = {
            hitokotoApi: '<?php echo addslashes(Helper::options()->hitokotoApi ?: "https://v1.hitokoto.cn/"); ?>',
            musicUrl: '<?php echo addslashes(Helper::options()->musicUrl ?: ""); ?>',
            qqPayQr: '<?php echo addslashes(Helper::options()->qqPayQr ?: ""); ?>',
            wechatQr: '<?php echo addslashes(Helper::options()->wechatQr ?: ""); ?>',
            alipayQr: '<?php echo addslashes(Helper::options()->alipayQr ?: ""); ?>',
            enableFunTools: <?php echo Helper::options()->enableFunTools ? 'true' : 'false'; ?>,
            websites: <?php echo json_encode(getWebsites() ?: []); ?>
        };
    </script>
    
</head>
<body class="bg-gray-50 text-gray-800 font-sans">
    <nav class="sticky top-0 z-50 bg-white/80 backdrop-blur-md border-b border-gray-200 px-4 py-3 shadow-sm">
        <div class="max-w-7xl mx-auto flex justify-between items-center">
            <a href="<?php $this->options->siteUrl(); ?>" class="text-xl font-bold text-primary flex items-center">
                <i class="fa fa-home mr-2"></i>
                <span><?php $this->options->siteTitle ? $this->options->siteTitle() : $this->options->title(); ?></span>
            </a>
            <div class="hidden md:flex space-x-6 items-center">
    <a href="<?php echo $this->options->siteUrl; ?>" class="text-gray-600 hover:text-primary transition-colors flex items-center">
        <i class="fa fa-home mr-1"></i>
        <span>首页</span>
    </a>
    
    <a href="<?php echo $this->options->siteUrl; ?>#about" class="text-gray-600 hover:text-primary transition-colors flex items-center">
        <i class="fa fa-user mr-1"></i>
        <span>关于我</span>
    </a>
    
    <a href="<?php echo $this->options->siteUrl; ?>#skills" class="text-gray-600 hover:text-primary transition-colors flex items-center">
        <i class="fa fa-code mr-1"></i>
        <span>技能</span>
    </a>
    
    <a href="<?php echo $this->options->siteUrl; ?>#projects" class="text-gray-600 hover:text-primary transition-colors flex items-center">
        <i class="fa fa-briefcase mr-1"></i>
        <span>项目</span>
    </a>
    
    <a href="<?php echo $this->options->siteUrl; ?>#articles" class="text-gray-600 hover:text-primary transition-colors flex items-center">
        <i class="fa fa-newspaper-o mr-1"></i>
        <span>最新文章</span>
    </a>
    
    <a href="<?php echo $this->options->siteUrl; ?>#websites" class="text-gray-600 hover:text-primary transition-colors flex items-center">
        <i class="fa fa-globe mr-1"></i>
        <span>其他网站</span>
    </a>
    
    <?php if (Helper::options()->enableFunTools): ?>
    <a href="<?php echo $this->options->siteUrl; ?>#fun" class="text-gray-600 hover:text-primary transition-colors flex items-center">
        <i class="fa fa-gamepad mr-1"></i>
        <span>娱乐</span>
    </a>
    <?php endif; ?>
    
    <?php if (Helper::options()->wechatQr || Helper::options()->alipayQr || Helper::options()->qqPayQr): ?>
    <a href="<?php echo $this->options->siteUrl; ?>#sponsor" class="text-gray-600 hover:text-primary transition-colors flex items-center">
        <i class="fa fa-heart mr-1"></i>
        <span>赞助我</span>
    </a>
    <?php endif; ?>
    
    <a href="<?php echo $this->options->siteUrl; ?>#contact" class="text-gray-600 hover:text-primary transition-colors flex items-center">
        <i class="fa fa-envelope mr-1"></i>
        <span>联系我</span>
    </a>
</div>

            <button id="mobileMenuBtn" class="md:hidden text-gray-500 focus:outline-none">
                <i class="fa fa-bars text-xl"></i>
            </button>
        </div>
    </nav>
    
        <div id="mobileMenu" class="fixed inset-0 z-40 bg-transparent transform -translate-x-full transition-transform duration-300 md:hidden">
        <div class="w-48 h-full bg-white shadow-xl flex flex-col">
            <div class="p-4 border-b border-gray-200 flex justify-between items-center">
                <span class="text-lg font-bold text-primary">菜单</span>
                <button id="closeMobileMenu" class="text-gray-500">
                    <i class="fa fa-times text-xl"></i>
                </button>
            </div>
            <div class="flex-1 overflow-y-auto p-4">
    <div class="flex flex-col items-center space-y-3">
        <a href="<?php echo $this->options->siteUrl; ?>" class="w-full py-3 text-gray-600 hover:text-primary mobile-link flex items-center justify-center hover:bg-gray-50 rounded-lg transition-all">
            <i class="fa fa-home mr-2"></i> 首页
        </a>
        <a href="<?php echo $this->options->siteUrl; ?>#about" class="w-full py-3 text-gray-600 hover:text-primary mobile-link flex items-center justify-center hover:bg-gray-50 rounded-lg transition-all">
            <i class="fa fa-user mr-2"></i> 关于我
        </a>
        <a href="<?php echo $this->options->siteUrl; ?>#skills" class="w-full py-3 text-gray-600 hover:text-primary mobile-link flex items-center justify-center hover:bg-gray-50 rounded-lg transition-all">
            <i class="fa fa-code mr-2"></i> 技能
        </a>
        <a href="<?php echo $this->options->siteUrl; ?>#projects" class="w-full py-3 text-gray-600 hover:text-primary mobile-link flex items-center justify-center hover:bg-gray-50 rounded-lg transition-all">
            <i class="fa fa-briefcase mr-2"></i> 项目
        </a>
        <a href="<?php echo $this->options->siteUrl; ?>#articles" class="w-full py-3 text-gray-600 hover:text-primary mobile-link flex items-center justify-center hover:bg-gray-50 rounded-lg transition-all">
            <i class="fa fa-newspaper-o mr-2"></i> 最新文章
        </a>
        <a href="<?php echo $this->options->siteUrl; ?>#websites" class="w-full py-3 text-gray-600 hover:text-primary mobile-link flex items-center justify-center hover:bg-gray-50 rounded-lg transition-all">
            <i class="fa fa-globe mr-2"></i> 其他网站
        </a>
        
        <?php if (Helper::options()->enableFunTools): ?>
        <a href="<?php echo $this->options->siteUrl; ?>#fun" class="w-full py-3 text-gray-600 hover:text-primary mobile-link flex items-center justify-center hover:bg-gray-50 rounded-lg transition-all">
            <i class="fa fa-gamepad mr-2"></i> 娱乐
        </a>
        <?php endif; ?>
        
        <?php if (Helper::options()->wechatQr || Helper::options()->alipayQr || Helper::options()->qqPayQr): ?>
        <a href="<?php echo $this->options->siteUrl; ?>#sponsor" class="w-full py-3 text-gray-600 hover:text-primary mobile-link flex items-center justify-center hover:bg-gray-50 rounded-lg transition-all">
            <i class="fa fa-heart mr-2"></i> 赞助我
        </a>
        <?php endif; ?>
        
        <a href="<?php echo $this->options->siteUrl; ?>#contact" class="w-full py-3 text-gray-600 hover:text-primary mobile-link flex items-center justify-center hover:bg-gray-50 rounded-lg transition-all">
            <i class="fa fa-envelope mr-2"></i> 联系我
        </a>
    </div>
</div>
        </div>
    </div>