<?php
if (!defined('__TYPECHO_ROOT_DIR__')) {
    setArchiveType(404);
    exit;
}
function themeInit($archive) {    
    if (isset($_GET['backup'])) {
        return;
    }
    
    if ($archive->is('archive') && !$archive->is('tag')) {
        $archive->setArchiveType('404');
        http_response_code(404);
        return;
    }
}

function themeConfig($form) {
    $siteTitle = new Typecho_Widget_Helper_Form_Element_Text('siteTitle', NULL, '个人主页', _t('网站标题'));
    $form->addInput($siteTitle);
    
    $avatarType = new Typecho_Widget_Helper_Form_Element_Radio('avatarType', 
        array(
            'qq' => _t('QQ头像'),
            'custom' => _t('自定义链接')
        ), 'qq', _t('头像类型'));
    $form->addInput($avatarType);
    
    $qqNumber = new Typecho_Widget_Helper_Form_Element_Text('qqNumber', NULL, '859981914', _t('QQ号码'));
    $form->addInput($qqNumber);
    
    $avatarUrl = new Typecho_Widget_Helper_Form_Element_Text('avatarUrl', NULL, '', _t('头像链接'));
    $form->addInput($avatarUrl);
    
    $nickname = new Typecho_Widget_Helper_Form_Element_Text('nickname', NULL, '尘苍', _t('网名'));
    $form->addInput($nickname);
    
    $about = new Typecho_Widget_Helper_Form_Element_Text('about', NULL, '关于我', _t('关于我标题自定义'));
    $form->addInput($about);
    
    $introduce = new Typecho_Widget_Helper_Form_Element_Text('introduce', NULL, '个人介绍', _t('个人介绍自定义'));
    $form->addInput($introduce);
    
    $description = new Typecho_Widget_Helper_Form_Element_Textarea('description', NULL, '以尘渡山海，枕苍听晚风。一身风尘，满目苍茫，心向山河，不问归途。', _t('简介'));
    $form->addInput($description);
    
    $bio = new Typecho_Widget_Helper_Form_Element_Textarea('bio', NULL, '我是尘苍，以尘为念，以苍为怀。偏爱人间烟火，亦喜山河辽阔，在浮沉俗世里沉淀心性，于岁月苍茫中温柔自持，随心随性，向阳而生，静度时光，不问纷扰。', _t('个人介绍'));
    $form->addInput($bio);
    
    $form->addInput(new Typecho_Widget_Helper_Form_Element_Text('expText', NULL, _t('年开发经验'), _t('开发经验-文字描述自定义'), _t('例如：年开发经验')));
    
    $expYears = new Typecho_Widget_Helper_Form_Element_Text('expYears', NULL, '5', _t('开发经验(年)'));
    $form->addInput($expYears);
    
    $form->addInput(new Typecho_Widget_Helper_Form_Element_Text('projectsText', NULL, _t('完成项目'), _t('完成项目-文字描述自定义'), _t('例如：完成项目')));
    
    $projectsCount = new Typecho_Widget_Helper_Form_Element_Text('projectsCount', NULL, '20', _t('完成项目'));
    $form->addInput($projectsCount);
    
    $form->addInput(new Typecho_Widget_Helper_Form_Element_Text('skillsText', NULL, _t('技术栈掌握'), _t('技术栈掌握-文字描述自定义'), _t('例如：技术栈掌握')));
    
    $skillsCount = new Typecho_Widget_Helper_Form_Element_Text('skillsCount', NULL, '10', _t('技术栈掌握'));
    $form->addInput($skillsCount);
    
    $form->addInput(new Typecho_Widget_Helper_Form_Element_Text('commitsText', NULL, _t('代码提交'), _t('代码提交-文字描述自定义'), _t('例如：代码提交')));
    
    $commitsCount = new Typecho_Widget_Helper_Form_Element_Text('commitsCount', NULL, '5000', _t('代码提交'));
    $form->addInput($commitsCount);
    
    $achievement = new Typecho_Widget_Helper_Form_Element_Text('achievement', NULL, '成就', _t('成就标题自定义'));
    $form->addInput($achievement);
    
    $achievementsJson = new Typecho_Widget_Helper_Form_Element_Textarea('achievementsJson', NULL, '[{"icon":"fa-cutlery","title":"干饭专业户","desc":"干饭协会 · 终身会员"},{"icon":"fa-bed","title":"睡神认证","desc":"家里蹲躺平中心 · 荣誉院士"},{"icon":"fa-gamepad","title":"游戏资深玩家","desc":"峡谷混子 · 在线摆烂"}]', _t('成就列表 (JSON格式)'));
    $form->addInput($achievementsJson);
    
    $SkillTitle = new Typecho_Widget_Helper_Form_Element_Text('SkillTitle', NULL, '我会的技能', _t('技能标题自定义'));
    $form->addInput($SkillTitle);
    
    $skillsJson = new Typecho_Widget_Helper_Form_Element_Textarea('skillsJson', NULL, '[{"icon":"fa-bicycle","title":"骑行追风","desc":"通勤代步+休闲骑行，大街小巷随心逛，不问终点只图自在，风吹耳边超治愈。","name1":"日常骑行","rate1":"95","name2":"环城兜圈","rate2":"92"},{"icon":"fa-home","title":"宅家摆烂","desc":"窝家追剧刷视频，泡茶嗑零食发呆，不用社交不用赶路，躺平就是最大快乐。","name1":"追剧发呆","rate1":"88","name2":"零食茶饮","rate2":"85"},{"icon":"fa-map-marker","title":"街头闲逛","desc":"饭后压马路逛市集，打卡街边小店，漫无目的散步，感受人间烟火气。","name1":"街头闲逛","rate1":"78","name2":"市集打卡","rate2":"80"}]', _t('技能列表 (JSON格式)'));
    $form->addInput($skillsJson);
    
    $ProjectTitle = new Typecho_Widget_Helper_Form_Element_Text('ProjectTitle', NULL, '我的项目', _t('我的项目标题自定义'));
    $form->addInput($ProjectTitle);
    
    $articleTitle = new Typecho_Widget_Helper_Form_Element_Text('articleTitle', NULL, '最新文章', _t('最新文章标题自定义'));
    $form->addInput($articleTitle);
    
    $links = new Typecho_Widget_Helper_Form_Element_Text('links', NULL, '我的其他网站', _t('我的其他网站标题自定义'));
    $form->addInput($links);
    
    $websitesJson = new Typecho_Widget_Helper_Form_Element_Textarea('websitesJson', NULL, '[{"name":"个人主页官网","url":"https://www.jueai.chat","icon":"fa-globe","type":"icon"},{"name":"绝爱拾光去水印","url":"https://wx.jueai.chat/","icon":"fa-scissors","type":"icon"},{"name":"闲鱼发货助手","url":"https://appstore.jueai.chat/","icon":"fa-cubes","type":"icon"}]', _t('网站列表 (JSON格式)'));
    $form->addInput($websitesJson);
    
    $contactsJson = new Typecho_Widget_Helper_Form_Element_Textarea('contactsJson', NULL, '[{"type":"email","value":"support@jueai.chat","label":"邮箱","icon":"fa-envelope","action":"mailto"},{"type":"qq","value":"859981914","label":"QQ","icon":"fa-qq","action":"qq"},{"type":"wechat","value":"QWHKZX","label":"微信","icon":"fa-weixin","action":"copy"},{"type":"github","value":"https://github.com/xliaoy","label":"GitHub","icon":"fa-github","action":"link"},{"type":"phone","value":"18888888888","label":"电话","icon":"fa-phone","action":"tel"}]', _t('联系方式 (JSON格式)'));
    $form->addInput($contactsJson);
    
    $wechatQr = new Typecho_Widget_Helper_Form_Element_Text('wechatQr', NULL, 'https://www.jueai.chat/usr/themes/nebula/assets/img/wxskm.png', _t('微信收款码链接'));
    $form->addInput($wechatQr);
    
    $alipayQr = new Typecho_Widget_Helper_Form_Element_Text('alipayQr', NULL, 'https://www.jueai.chat/usr/themes/nebula/assets/img/zfbskm.png', _t('支付宝收款码链接'));
    $form->addInput($alipayQr);
    
    $qqPayQr = new Typecho_Widget_Helper_Form_Element_Text('qqPayQr', NULL, 'https://www.jueai.chat/usr/themes/nebula/assets/img/qqskm.png', _t('QQ收款码链接'));
    $form->addInput($qqPayQr);
    
    $wechatgzhQr = new Typecho_Widget_Helper_Form_Element_Text('wechatgzhQr', NULL, 'https://www.jueai.chat/usr/themes/nebula/assets/img/gzh.png', _t('微信公众号二维码链接'));
    $form->addInput($wechatgzhQr);
    $enableFunTools = new Typecho_Widget_Helper_Form_Element_Radio('enableFunTools', 
        array('1' => _t('开启'), '0' => _t('关闭')), '1', _t('开启娱乐小工具'));
    $form->addInput($enableFunTools);
    
    $musicUrl = new Typecho_Widget_Helper_Form_Element_Text('musicUrl', NULL, 'http://aqqmusic.tc.qq.com/C4000017ym7Q1a3P4c.m4a?guid=788837155&vkey=1CA71AD57DFA6AD82A948EEEC9DAAFBE3C1A69401C55B57D87767852A68AD4EFB1D55F4B4B20F0CB94F69E69A4AD93C191BE61C322E90622__v2b9aacc9&uin=&fromtag=120032', _t('音乐播放链接'));
    $form->addInput($musicUrl);
        
    $hitokotoApi = new Typecho_Widget_Helper_Form_Element_Text('hitokotoApi', NULL, 'https://v1.hitokoto.cn/', _t('随机一言API地址'));
    $form->addInput($hitokotoApi);    
    
    $beian = new Typecho_Widget_Helper_Form_Element_Text('beian', NULL, '豫ICP备2025152676号-1', _t('备案号'));
    $form->addInput($beian);
    
    echo '<div class="typecho-page-title"><h2>JueAi Ui 主题配置</h2></div>';
    echo '<div style="margin:20px 0; padding:15px; background:#f8f9fa; border-radius:5px; border:1px solid #e9ecef;">';
    echo '<h3 style="margin-top:0;">配置备份管理</h3>';
    
    $backupInfo = getBackupInfo();
    if ($backupInfo['exists']) {
        echo '<div style="margin-bottom:15px;">';
        echo '<p><strong>已发现备份配置：</strong></p>';
        echo '<ul style="margin:10px 0; padding-left:20px;">';
        echo '<li>主题：' . htmlspecialchars($backupInfo['theme']) . '</li>';
        echo '<li>版本：' . htmlspecialchars($backupInfo['version']) . '</li>';
        echo '<li>备份时间：' . htmlspecialchars($backupInfo['time']) . '</li>';
        echo '</ul>';
        echo '</div>';
    } else {
        echo '<p>暂无备份配置</p>';
    }
    
    echo '<div style="display:flex; gap:10px;">';
    echo '<button type="button" class="btn" onclick="createBackup()" style="padding:8px 16px; background:#007bff; color:white; border:none; border-radius:4px; cursor:pointer;">备份</button>';
    if ($backupInfo['exists']) {
        echo '<button type="button" class="btn" onclick="restoreBackup()" style="padding:8px 16px; background:#28a745; color:white; border:none; border-radius:4px; cursor:pointer;">恢复</button>';
    }
    echo '<button type="button" class="btn" onclick="exportBackup()" style="padding:8px 16px; background:#6c757d; color:white; border:none; border-radius:4px; cursor:pointer;">导出</button>';
    echo '<input type="file" id="importFile" accept=".json" style="display:none;">';
    echo '<button type="button" class="btn" onclick="importBackup()" style="padding:8px 16px; background:#17a2b8; color:white; border:none; border-radius:4px; cursor:pointer;">导入</button>';
    echo '</div>';
    echo '</div>';
    
    echo '<script>
    function createBackup() {
        fetch("' . Helper::options()->adminUrl . 'theme-editor.php?config&backup=create&theme=' . Helper::options()->theme . '")
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert("配置备份成功！");
                    location.reload();
                } else {
                    alert("备份失败：" + data.message);
                }
            })
            .catch(error => {
                alert("网络错误：" + error);
            });
    }
    
    function restoreBackup() {
        if (confirm("确定要恢复备份配置吗？这将覆盖当前所有设置！")) {
            fetch("' . Helper::options()->adminUrl . 'theme-editor.php?config&backup=restore&theme=' . Helper::options()->theme . '")
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        alert("配置恢复成功！页面将刷新");
                        location.reload();
                    } else {
                        alert("恢复失败：" + data.message);
                    }
                })
                .catch(error => {
                    alert("网络错误：" + error);
                });
        }
    }
    
    function exportBackup() {
        fetch("' . Helper::options()->adminUrl . 'theme-editor.php?config&backup=export&theme=' . Helper::options()->theme . '")
            .then(response => response.blob())
            .then(blob => {
                const url = window.URL.createObjectURL(blob);
                const a = document.createElement("a");
                a.href = url;
                a.download = "JueAiUi-backup-" + new Date().toISOString().slice(0,10) + ".json";
                document.body.appendChild(a);
                a.click();
                window.URL.revokeObjectURL(url);
                document.body.removeChild(a);
            })
            .catch(error => {
                alert("导出失败：" + error);
            });
    }
    
    function importBackup() {
        document.getElementById("importFile").click();
    }
    
    document.getElementById("importFile").addEventListener("change", function(e) {
        const file = e.target.files[0];
        if (!file) return;
        
        const reader = new FileReader();
        reader.onload = function(event) {
            const content = event.target.result;
            try {
                JSON.parse(content);
                
                if (confirm("确定要导入配置吗？这将覆盖当前所有设置！")) {
                    const formData = new FormData();
                    formData.append("backup_file", file);
                    
                    fetch("' . Helper::options()->adminUrl . 'theme-editor.php?config&backup=import&theme=' . Helper::options()->theme . '", {
                        method: "POST",
                        body: formData
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            alert("配置导入成功！页面将刷新");
                            location.reload();
                        } else {
                            alert("导入失败：" + data.message);
                        }
                    })
                    .catch(error => {
                        alert("网络错误：" + error);
                    });
                }
            } catch (error) {
                alert("文件格式错误，请选择有效的JSON文件");
            }
        };
        reader.readAsText(file);
        e.target.value = "";
    });
    </script>';
}
function getAvatar() {
    $options = Helper::options();
    $avatarType = $options->avatarType;
    $avatarUrl = $options->avatarUrl;
    $qqNumber = $options->qqNumber;
    
    switch ($avatarType) {
        case 'qq':
            return "https://q1.qlogo.cn/g?b=qq&nk=" . ($qqNumber ?: '10001') . "&s=640";
        case 'custom':
            return $avatarUrl ?: '';
        default:
            return $options->avatarUrl ?: '';
    }
}
function getFirstImage($content) {
    preg_match('/<img[^>]+src="([^"]+)"/', $content, $matches);
    if (!empty($matches[1])) {
        return $matches[1];
    }
    
    preg_match('/!\[[^\]]*\]\[(\d+)\]/', $content, $mdMatches);
    if (!empty($mdMatches[1])) {
        $pattern = '/\[' . $mdMatches[1] . '\]:\s*(\S+)/';
        preg_match($pattern, $content, $linkMatches);
        if (!empty($linkMatches[1])) {
            return $linkMatches[1];
        }
    }
    
    preg_match('/!\[[^\]]*\]\((\S+)\)/', $content, $simpleMatches);
    if (!empty($simpleMatches[1])) {
        return $simpleMatches[1];
    }
    
    return false;
}
function getFlexibleData($optionKey, $default = array()) {
    $data = Helper::options()->{$optionKey};
    if ($data) {
        $decoded = json_decode($data, true);
        if (json_last_error() === JSON_ERROR_NONE) {
            return $decoded;
        }
    }
    return $default;
}
function getSkills() {
    return getFlexibleData('skillsJson');
}
function getWebsites() {
    return getFlexibleData('websitesJson');
}
function getAchievements() {
    return getFlexibleData('achievementsJson');
}
function getContacts() {
    return getFlexibleData('contactsJson');
}
function getContactLink($contact) {
    if (!isset($contact['value']) || empty($contact['value'])) {
        return '#';
    }
    
    switch ($contact['action']) {
        case 'mailto':
            return "mailto:{$contact['value']}";
        case 'qq':
            return "https://wpa.qq.com/msgrd?v=3&uin={$contact['value']}&site=qq&menu=yes";
        case 'github':
            return "https://github.com/" . ltrim($contact['value'], '@');
        case 'copy':
            return 'javascript:void(0)';
        case 'link':
            return $contact['value'];
        default:
            return '#';
    }
}
function getCopyScript($value) {
    return "navigator.clipboard.writeText('{$value}').then(() => alert('已复制到剪贴板'));";
}
function getProjects() {
    $db = Typecho_Db::get();
    
    $cat = $db->fetchRow($db->select('mid')
        ->from('table.metas')
        ->where('type = ?', 'category')
        ->where('name = ?', '我的项目')
        ->limit(1));
    
    if ($cat) {
        $select = $db->select('table.contents.cid', 
                               'table.contents.title', 
                               'table.contents.slug', 
                               'table.contents.created', 
                               'table.contents.text', 
                               'table.contents.modified', 
                               'table.contents.authorId', 
                               'table.contents.type', 
                               'table.contents.status', 
                               'table.contents.commentsNum', 
                               'table.contents.order', 
                               'table.contents.template', 
                               'table.contents.password', 
                               'table.contents.allowComment', 
                               'table.contents.allowPing', 
                               'table.contents.allowFeed')
            ->from('table.contents')
            ->join('table.relationships', 'table.contents.cid = table.relationships.cid')
            ->where('table.relationships.mid = ?', $cat['mid'])
            ->where('table.contents.type = ?', 'post')
            ->where('table.contents.status = ?', 'publish')
            ->order('table.contents.created', Typecho_Db::SORT_DESC);
        
        return $db->fetchAll($select);
    }
    
    return array();
}
function getPostTags($cid) {
    $db = Typecho_Db::get();
    
    $tags = $db->fetchAll($db->select('table.metas.name')
        ->from('table.metas')
        ->join('table.relationships', 'table.metas.mid = table.relationships.mid')
        ->where('table.relationships.cid = ?', $cid)
        ->where('table.metas.type = ?', 'tag'));
    
    return $tags;
}
function getPostExcerpt($content, $length = 150) {
    $content = preg_replace('/!\[[^\]]*\]\[(\d+)\]/', '', $content);
    $content = preg_replace('/!\[[^\]]*\]\(([^)]+)\)/', '', $content);
    $content = preg_replace('/<img[^>]+>/', '', $content);
    $content = preg_replace('/\[(\d+)\]:\s*\S+/', '', $content);
    
    $content = preg_replace('/\[([^\]]+)\]\(([^)]+)\)/', '$1', $content);
    
    $content = strip_tags($content);
    
    return mb_substr($content, 0, $length, 'UTF-8') . '...';
}
function getPostPermalink($cid) {
    try {
        return Helper::options()->index . '/archives/' . $cid . '/';        
    } catch (Exception $e) {
        try {
            $db = Typecho_Db::get();
            $post = $db->fetchRow($db->select('slug')
                ->from('table.contents')
                ->where('cid = ?', $cid)
                ->limit(1));
            
            if ($post) {
                return Helper::options()->index . '/archives/' . $post['slug'] . '/';
            }
        } catch (Exception $e2) {
        }
        
        return '#';
    }
}
function getProjectThumbnail($content, $cid) {
    $db = Typecho_Db::get();
    
    $field = $db->fetchRow($db->select('str_value')
        ->from('table.fields')
        ->where('cid = ?', $cid)
        ->where('name = ?', 'thumbnail'));
    
    if ($field && $field['str_value']) {
        return $field['str_value'];
    }
    
    return getFirstImage($content);
}
function getProjectsWithLinks() {
    $db = Typecho_Db::get();
    
    $cat = $db->fetchRow($db->select('mid')
        ->from('table.metas')
        ->where('type = ?', 'category')
        ->where('name = ?', '我的项目')
        ->limit(1));
    
    if ($cat) {
        $select = $db->select('table.contents.cid', 
                               'table.contents.title', 
                               'table.contents.slug', 
                               'table.contents.created', 
                               'table.contents.text', 
                               'table.contents.modified', 
                               'table.contents.authorId', 
                               'table.contents.type', 
                               'table.contents.status', 
                               'table.contents.commentsNum')
            ->from('table.contents')
            ->join('table.relationships', 'table.contents.cid = table.relationships.cid')
            ->where('table.relationships.mid = ?', $cat['mid'])
            ->where('table.contents.type = ?', 'post')
            ->where('table.contents.status = ?', 'publish')
            ->order('table.contents.created', Typecho_Db::SORT_DESC)
            ->limit(6);
        
        $projects = $db->fetchAll($select);
        
        foreach ($projects as &$project) {
            $project['permalink'] = getPostPermalink($project['cid']);
        }
        
        return $projects;
    }
    
    return array();
}
function getLatestArticlesWithLinks($limit = 12, $excludeCategory = '我的项目') {
    $db = Typecho_Db::get();
    
    try {
        $select = $db->select('cid', 'title', 'slug', 'created', 'modified', 'authorId', 'type', 'status', 'commentsNum')
            ->from('table.contents')
            ->where('status = ?', 'publish')
            ->where('type = ?', 'post')
            ->order('created', Typecho_Db::SORT_DESC)
            ->limit($limit * 3);
        
        $allArticles = $db->fetchAll($select);
        
        $excludeIds = array();
        if ($excludeCategory && $excludeCategory != '') {
            $excludeCat = $db->fetchRow($db->select('mid')
                ->from('table.metas')
                ->where('type = ?', 'category')
                ->where('name = ?', $excludeCategory));
            
            if ($excludeCat) {
                $excludePosts = $db->fetchAll($db->select('cid')
                    ->from('table.relationships')
                    ->where('mid = ?', $excludeCat['mid']));
                
                foreach ($excludePosts as $post) {
                    $excludeIds[] = $post['cid'];
                }
            }
        }
        
        $articles = array();
        foreach ($allArticles as $article) {
            if (!in_array($article['cid'], $excludeIds)) {
                $articles[] = $article;
            }
            if (count($articles) >= $limit) {
                break;
            }
        }
        
        foreach ($articles as &$article) {
            $article['permalink'] = getPostPermalink($article['cid']);
        }
        
        return $articles;
        
    } catch (Exception $e) {
        error_log('获取最新文章失败: ' . $e->getMessage());
        return array();
    }
}
function backupThemeConfig() {
    $options = Helper::options();
    $themeName = $options->theme;
    $db = Typecho_Db::get();
    
    $currentConfig = $db->fetchRow($db->select('value')
        ->from('table.options')
        ->where('name = ?', 'theme:' . $themeName)
        ->limit(1));
    
    if (!$currentConfig || empty($currentConfig['value'])) {
        return false;
    }
    
    $configArray = @unserialize($currentConfig['value']);
    if (!is_array($configArray)) {
        return false;
    }
    
    $backupData = array(
        'data' => $configArray,
        '_backup_timestamp' => time(),
        '_backup_version' => '1.0.4',
        '_backup_theme' => $themeName
    );
    
    $backupOptionName = 'theme:' . $themeName . '_backup';
    $exist = $db->fetchRow($db->select()
        ->from('table.options')
        ->where('name = ?', $backupOptionName)
        ->limit(1));
    
    if ($exist) {
        $db->query($db->update('table.options')
            ->rows(array('value' => json_encode($backupData, JSON_UNESCAPED_UNICODE)))
            ->where('name = ?', $backupOptionName));
    } else {
        $db->query($db->insert('table.options')
            ->rows(array(
                'name' => $backupOptionName,
                'value' => json_encode($backupData, JSON_UNESCAPED_UNICODE),
                'user' => 0
            )));
    }
    
    return true;
}
function restoreThemeConfig() {
    $options = Helper::options();
    $themeName = $options->theme;
    $db = Typecho_Db::get();
    
    $backupOptionName = 'theme:' . $themeName . '_backup';
    $backup = $db->fetchRow($db->select('value')
        ->from('table.options')
        ->where('name = ?', $backupOptionName)
        ->limit(1));
    
    if (!$backup || empty($backup['value'])) {
        return false;
    }
    
    $backupData = json_decode($backup['value'], true);
    if (!is_array($backupData) || !isset($backupData['data']) || !is_array($backupData['data'])) {
        return false;
    }
    
    $serializedConfig = serialize($backupData['data']);
    $exist = $db->fetchRow($db->select()
        ->from('table.options')
        ->where('name = ?', 'theme:' . $themeName)
        ->limit(1));
    
    if ($exist) {
        $db->query($db->update('table.options')
            ->rows(array('value' => $serializedConfig))
            ->where('name = ?', 'theme:' . $themeName));
    } else {
        $db->query($db->insert('table.options')
            ->rows(array(
                'name' => 'theme:' . $themeName,
                'value' => $serializedConfig,
                'user' => 0
            )));
    }
    
    return true;
}
function exportBackupData() {
    $options = Helper::options();
    $themeName = $options->theme;
    $db = Typecho_Db::get();
    
    $backupOptionName = 'theme:' . $themeName . '_backup';
    $backup = $db->fetchRow($db->select('value')
        ->from('table.options')
        ->where('name = ?', $backupOptionName)
        ->limit(1));
    
    if (!$backup || empty($backup['value'])) {
        return null;
    }
    
    $backupData = json_decode($backup['value'], true);
    if (!is_array($backupData)) {
        return null;
    }
    
    $exportData = array(
        'theme' => $themeName,
        'version' => '1.0.4',
        'export_time' => date('Y-m-d H:i:s'),
        'export_timestamp' => time(),
        'backup_data' => $backupData
    );
    
    return json_encode($exportData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
}
function importBackupData($jsonData) {
    try {
        $importData = json_decode($jsonData, true);
        if (!is_array($importData) || json_last_error() !== JSON_ERROR_NONE) {
            return array('success' => false, 'message' => 'JSON格式错误');
        }
        
        $options = Helper::options();
        $currentTheme = $options->theme;
        if (!isset($importData['theme']) || $importData['theme'] !== $currentTheme) {
            return array('success' => false, 'message' => '备份文件主题与当前主题不匹配（当前主题：' . $currentTheme . '）');
        }
        
        if (!isset($importData['backup_data']['data']) || !is_array($importData['backup_data']['data'])) {
            return array('success' => false, 'message' => '备份数据格式错误');
        }
        
        $db = Typecho_Db::get();
        $backupData = array(
            'data' => $importData['backup_data']['data'],
            '_backup_timestamp' => time(),
            '_backup_version' => '1.0.4',
            '_backup_theme' => $currentTheme
        );
        
        $backupOptionName = 'theme:' . $currentTheme . '_backup';
        $exist = $db->fetchRow($db->select()
            ->from('table.options')
            ->where('name = ?', $backupOptionName)
            ->limit(1));
        
        if ($exist) {
            $db->query($db->update('table.options')
                ->rows(array('value' => json_encode($backupData, JSON_UNESCAPED_UNICODE)))
                ->where('name = ?', $backupOptionName));
        } else {
            $db->query($db->insert('table.options')
                ->rows(array(
                    'name' => $backupOptionName,
                    'value' => json_encode($backupData, JSON_UNESCAPED_UNICODE),
                    'user' => 0
                )));
        }
        
        return array('success' => true, 'message' => '备份导入成功');
        
    } catch (Exception $e) {
        return array('success' => false, 'message' => '导入失败: ' . $e->getMessage());
    }
}
function getBackupInfo() {
    $options = Helper::options();
    $themeName = $options->theme;
    $db = Typecho_Db::get();
    
    $backupOptionName = 'theme:' . $themeName . '_backup';
    $backup = $db->fetchRow($db->select('value')
        ->from('table.options')
        ->where('name = ?', $backupOptionName)
        ->limit(1));
    
    if (!$backup || empty($backup['value'])) {
        return array('exists' => false);
    }
    
    $data = json_decode($backup['value'], true);
    if (!is_array($data)) {
        return array('exists' => false);
    }
    
    return array(
        'exists' => true,
        'timestamp' => isset($data['_backup_timestamp']) ? $data['_backup_timestamp'] : 0,
        'version' => isset($data['_backup_version']) ? $data['_backup_version'] : '',
        'theme' => isset($data['_backup_theme']) ? $data['_backup_theme'] : $themeName,
        'time' => isset($data['_backup_timestamp']) ? date('Y-m-d H:i:s', $data['_backup_timestamp']) : '未知'
    );
}
if (isset($_GET['backup'])) {
    ob_clean();
    header('Content-Type: application/json');
    
    switch ($_GET['backup']) {
        case 'create':
            try {
                $result = backupThemeConfig();
                echo json_encode(array('success' => $result, 'message' => $result ? '备份成功' : '备份失败：未获取到当前主题配置'));
            } catch (Exception $e) {
                echo json_encode(array('success' => false, 'message' => '备份失败: ' . $e->getMessage()));
            }
            exit;
            
        case 'restore':
            try {
                $result = restoreThemeConfig();
                echo json_encode(array('success' => $result, 'message' => $result ? '恢复成功' : '恢复失败：未找到有效备份'));
            } catch (Exception $e) {
                echo json_encode(array('success' => false, 'message' => '恢复失败: ' . $e->getMessage()));
            }
            exit;
            
        case 'export':
            $exportData = exportBackupData();
            if ($exportData) {
                header('Content-Type: application/json');
                header('Content-Disposition: attachment; filename="JueAiUi-backup-' . date('Y-m-d') . '.json"');
                echo $exportData;
            } else {
                echo json_encode(array('success' => false, 'message' => '没有找到备份数据'));
            }
            exit;
            
        case 'import':
            if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['backup_file'])) {
                $file = $_FILES['backup_file'];
                if ($file['error'] === UPLOAD_ERR_OK) {
                    $content = file_get_contents($file['tmp_name']);
                    $result = importBackupData($content);
                    echo json_encode($result);
                } else {
                    echo json_encode(array('success' => false, 'message' => '文件上传失败'));
                }
                exit;
            }
            break;
    }
}
