<?php
if (!defined('__TYPECHO_ROOT_DIR__')) {
	http_response_code(404);
	exit;
}
?>
<footer class="bg-dark text-white py-12 px-4">
        <div class="max-w-7xl mx-auto">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-8 mb-8">
                <div>
                    <h3 class="text-lg font-semibold mb-4">关于我</h3>
                    <p class="text-gray-400 text-sm"><?php echo Helper::options()->description ?: '全栈开发者，热爱技术与创新。致力于打造高质量的数字产品。'; ?></p>
                </div>
                <div>
                    <h3 class="text-lg font-semibold mb-4">快速链接</h3>
                    <ul class="space-y-2 text-gray-400">
                        <li><a href="<?php echo $this->options->siteUrl; ?>#about" class="hover:text-white transition-colors">关于</a></li>
                        <li><a href="<?php echo $this->options->siteUrl; ?>#skills" class="hover:text-white transition-colors">技能</a></li>
                        <li><a href="<?php echo $this->options->siteUrl; ?>#projects" class="hover:text-white transition-colors">项目</a></li>
                        <li><a href="<?php echo $this->options->siteUrl; ?>#contact" class="hover:text-white transition-colors">联系</a></li>
                    </ul>
                </div>
                
       <div>
    <h3 class="text-lg font-semibold mb-4">关注公众号</h3>
    <p class="text-gray-400 text-sm mb-4">欢迎关注我们的微信公众号，获取最新资讯和动态</p>
    
    <?php
    $wechatgzhQr = Helper::options()->wechatgzhQr;
    if ($wechatgzhQr): ?>
        <div class="text-center">
            <div class="relative group inline-block w-32 h-32">
                <img src="<?php echo $wechatgzhQr; ?>" 
                     alt="微信公众号" 
                     class="w-full h-full rounded-lg border border-gray-700 transition-transform duration-300 group-hover:scale-105 object-cover">
                
                <div class="absolute top-0 left-0 w-full h-full bg-black/70 rounded-lg opacity-0 group-hover:opacity-100 flex items-center justify-center transition-opacity duration-300">
                    <p class="text-white text-sm font-medium text-center px-2">扫码关注公众号</p>
                </div>
            </div>
        </div>
        
        <p class="text-center text-gray-400 text-xs mt-3">
            长按识别二维码关注
        </p>
    <?php else: ?>
        <div class="text-center">
            <div class="relative inline-block w-32 h-32 bg-gray-800/50 rounded-lg border border-dashed border-gray-700">
                <div class="absolute inset-0 flex flex-col items-center justify-center text-center">
                    <i class="fa fa-weixin text-gray-500 text-3xl mb-2"></i>
                    <p class="text-gray-500 text-xs px-2">请在主题设置中<br>上传公众号二维码</p>
                </div>
            </div>
        </div>
        <p class="text-center text-gray-500 text-xs mt-3">
            主题设置 → 赞助设置 → 微信收款码链接
        </p>
    <?php endif; ?>
</div>
            
            <div class="border-t border-gray-800 pt-8 text-center text-gray-500 text-sm">
                <p>© <?php echo date('Y'); ?> <?php $this->options->title(); ?>. 保留所有权利.</p>
                
                <?php if (Helper::options()->beian): ?>
                <p class="mt-2">
                    <a href="https://beian.miit.gov.cn/" target="_blank" class="text-gray-400 hover:text-white transition-colors">
                        <?php echo Helper::options()->beian; ?>
                    </a>
                </p>
                <center>
                    <p>页面加载耗时 <?php echo number_format(microtime(true)-($_SERVER['REQUEST_TIME_FLOAT']??$_SERVER['REQUEST_TIME']),2); ?> 秒</p>
                </center>

                <?php endif; ?>

                <p class="mt-2">
                    Powered by <a href="http://typecho.org/" target="_blank" class="text-gray-400 hover:text-white transition-colors">Typecho</a> 
                    | Theme by <a href="<?php $this->options->siteUrl(); ?>" class="text-gray-400 hover:text-white transition-colors">JueAi Ui</a>
                </p>
            </div>
        </div>
    </footer>

    <div id="qrcodeModal" class="fixed inset-0 bg-black/50 z-50 hidden flex items-center justify-center">
        <div class="bg-white rounded-lg p-4 max-w-xs w-full mx-4 text-center">
            <h3 class="text-lg font-semibold mb-3" id="qrcodeTitle">收款码</h3>
            <img id="qrcodeImg" src="" alt="收款码" class="w-48 h-48 object-cover mx-auto rounded">
            <p class="mt-3 text-sm text-gray-500">
                感谢你的支持，我会继续创作更多有趣的内容。
            </p>
            <button onclick="document.getElementById('qrcodeModal').classList.add('hidden'); document.body.style.overflow = '';" 
                class="mt-4 w-full bg-gray-200 hover:bg-gray-300 text-gray-700 py-2 rounded-lg transition-colors">
                关闭
            </button>
        </div>
    </div>
    
    <button id="backToTop" class="fixed bottom-6 right-6 w-12 h-12 bg-primary text-white rounded-full shadow-lg flex items-center justify-center opacity-0 invisible transition-all duration-300 hover:bg-primary/90">
        <i class="fa fa-arrow-up"></i>
    </button>
    <script src="<?php $this->options->themeUrl('/assets/js/script.js'); ?>"></script>   
    <script src="<?php $this->options->themeUrl('assets/js/highlight.min.js'); ?>"></script>
    <script src="<?php $this->options->themeUrl('assets/js/glightbox.min.js'); ?>"></script>
    <script src="<?php $this->options->themeUrl('assets/js/head.js'); ?>"></script>
    <script src="<?php $this->options->themeUrl('assets/js/login.js'); ?>" nonce="<?php echo $this->options->nonce ?: ''; ?>"></script>  

    <?php $this->footer(); ?>
</body>
</html>