<?php
if (!defined('__TYPECHO_ROOT_DIR__')) {
	http_response_code(404);
	exit;
}
?>

<?php 
$this->comments()->setPageSize(6);
$comments = $this->comments();
?>

<div id="comments" class="space-y-6">
    <?php if ($comments->have()): ?>
        <div class="flex items-center justify-between mb-6">
            <h3 class="text-xl font-bold text-gray-800">
                <?php $this->commentsNum(_t('暂无评论'), _t('仅有一条评论'), _t('已有 %d 条评论')); ?>
            </h3>
            
            <?php if ($comments->getTotal() > 6): ?>
            <div class="flex items-center space-x-2 text-sm">
                <span class="text-gray-500">第 <?php echo $comments->currentPage; ?> 页 / 共 <?php echo $comments->getTotalPage(); ?> 页</span>
            </div>
            <?php endif; ?>
        </div>

        <div class="space-y-6">
            <?php while($comments->next()): ?>
            <div id="<?php $comments->theId(); ?>" class="comment-item bg-white rounded-xl p-4 shadow-nebulaui hover:shadow-nebulaui-hover transition-shadow duration-300">
                <div class="flex">
                    <div class="flex-shrink-0 mr-4">
                        <?php if ($comments->mail): ?>
                            <?php 
                            $safeMail = htmlspecialchars($comments->mail, ENT_QUOTES, 'UTF-8');
                            $mailHash = md5($safeMail);
                            ?>
                            <img src="https://weavatar.com/avatar/<?php echo $mailHash; ?>?s=50&d=identicon" 
                                 alt="<?php echo htmlspecialchars($comments->authorName, ENT_QUOTES, 'UTF-8'); ?>"
                                 class="w-10 h-10 rounded-full border-2 border-white shadow-sm"
                                 onerror="this.onerror=null;this.src='data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNTAiIGhlaWdodD0iNTAiIHZpZXdCb3g9IjAgMCA1MCA1MCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48Y2lyY2xlIGN4PSIyNSIgY3k9IjI1IiByPSIyNSIgZmlsbD0iIzRGNjBFNSIvPjxwYXRoIGQ9Ik0xNiAxOEMxNiAxNS43OTA5IDE3Ljc5MDkgMTQgMjAgMTRIMzBDMzIuMjA5MSAxNCAzNCAxNS43OTA5IDM0IDE4VjMyQzM0IDM0LjIwOTEgMzIuMjA5MSAzNiAzMCAzNkgyMEMxNy43OTA5IDM2IDE2IDM0LjIwOTEgMTYgMzJWMThaIiBmaWxsPSJ3aGl0ZSIvPjxwYXRoIGQ9Ik0yNSAyNUMzMC41MjI4IDI1IDM1IDIwLjUyMjggMzUgMTVDMzUgOS40NzcxNSAzMC41MjI4IDUgMjUgNUMxOS40NzcxIDUgMTUgOS40NzcxNSAxNSAxNUMxNSAyMC41MjI4IDE5LjQ3NzEgMjUgMjUgMjVaIiBmaWxsPSJ3aGl0ZSIvPjwvc3ZnPg=='">
                        <?php else: ?>
                            <div class="w-10 h-10 rounded-full bg-primary/10 flex items-center justify-center">
                                <svg class="w-5 h-5 text-primary" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z" clip-rule="evenodd"></path>
                                </svg>
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="flex-1 min-w-0">
                        <div class="flex items-center mb-1">
                            <span class="font-medium text-gray-800 mr-2"><?php 
                                echo htmlspecialchars($comments->authorName, ENT_QUOTES, 'UTF-8');
                            ?></span>
                            <?php if ($comments->authorId == $this->authorId): ?>
                                <span class="px-1.5 py-0.5 text-xs bg-primary/10 text-primary rounded-full font-medium">作者</span>
                            <?php endif; ?>
                        </div>
                        
                        <div class="text-gray-700 mb-2 comment-content">
                            <?php 
                            $content = $comments->content;                          
                            $allowedTags = '<p><br><strong><b><em><i><u><s><strike><del><ins><code><pre><blockquote><ul><ol><li><a><img><span><div><h1><h2><h3><h4><h5><h6>';
                            $content = strip_tags($content, $allowedTags);
                            $content = preg_replace_callback('/<(\w+)([^>]*)>/i', function($matches) {
                                $tag = $matches[1];
                                $attrs = $matches[2];
                                $allowedAttributes = [
                                    'a' => ['href', 'title', 'target', 'rel'],
                                    'img' => ['src', 'alt', 'title', 'width', 'height']
                                ];
                                
                                if (isset($allowedAttributes[strtolower($tag)])) {
                                    preg_match_all('/(\w+)\s*=\s*"([^"]*)"/', $attrs, $attrMatches, PREG_SET_ORDER);
                                    $safeAttrs = [];
                                    
                                    foreach ($attrMatches as $attr) {
                                        $attrName = strtolower($attr[1]);
                                        $attrValue = htmlspecialchars($attr[2], ENT_QUOTES, 'UTF-8');
                                        
                                        if (in_array($attrName, $allowedAttributes[strtolower($tag)])) {
                                            if ($tag == 'a' && $attrName == 'href') {                                                
                                                if (filter_var($attrValue, FILTER_VALIDATE_URL)) {
                                                    $safeAttrs[] = $attrName . '="' . $attrValue . '"';
                                                }
                                            }
                                            elseif ($tag == 'img' && $attrName == 'src') {
                                                if (filter_var($attrValue, FILTER_VALIDATE_URL)) {
                                                    $safeAttrs[] = $attrName . '="' . $attrValue . '"';
                                                }
                                            }
                                            else {
                                                $safeAttrs[] = $attrName . '="' . $attrValue . '"';
                                            }
                                        }
                                    }
                                    
                                    $safeAttrsStr = !empty($safeAttrs) ? ' ' . implode(' ', $safeAttrs) : '';
                                    return '<' . $tag . $safeAttrsStr . '>';
                                }
                                
                                return '<' . $tag . '>';
                            }, $content);                            
                            echo $content;
                            ?>
                        </div>
                                                
                        <div class="flex items-center justify-between text-sm text-gray-500 mt-2 pt-2 border-t border-gray-100">
                            <span class="inline-flex items-center">
                                <svg class="w-3.5 h-3.5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                <?php echo htmlspecialchars($comments->date('Y-m-d H:i'), ENT_QUOTES, 'UTF-8'); ?>
                            </span>
                            
                            <a href="<?php echo htmlspecialchars($comments->replyUrl(), ENT_QUOTES, 'UTF-8'); ?>" 
                               class="text-primary hover:text-primary/80 text-sm inline-flex items-center comment-reply-link"
                               data-author="<?php echo htmlspecialchars($comments->authorName, ENT_QUOTES, 'UTF-8'); ?>">
                                <svg class="w-3.5 h-3.5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h10a8 8 0 018 8v2M3 10l6 6m-6-6l6-6"></path>
                                </svg>
                                回复
                            </a>
                        </div>
                    </div>
                </div>
                
                <?php if ($comments->children): ?>
                <div class="mt-4 ml-12 pl-4 border-l-2 border-gray-100">
                    <?php $comments->threadedComments(); ?>
                </div>
                <?php endif; ?>
            </div>
            <?php endwhile; ?>
        </div>

        <?php if ($comments->getTotal() > 6): ?>
            <div class="mt-8 pt-6 border-t border-gray-200">
                <?php $comments->pageNav('&laquo; 前一页', '后一页 &raquo;', 3, '...', array(
                    'wrapTag' => 'nav',
                    'wrapClass' => 'flex items-center justify-center space-x-2',
                    'itemTag' => 'span',
                    'textTag' => 'a',
                    'currentClass' => 'bg-primary text-white px-3 py-1.5 rounded-lg font-medium',
                    'prevClass' => 'px-3 py-1.5 rounded-lg border border-gray-300 hover:bg-gray-50 text-gray-700 font-medium',
                    'nextClass' => 'px-3 py-1.5 rounded-lg border border-gray-300 hover:bg-gray-50 text-gray-700 font-medium',
                    'prevText' => '&laquo; 前一页',
                    'nextText' => '后一页 &raquo;'
                )); ?>
            </div>
        <?php endif; ?>

    <?php else: ?>
        <div class="text-center py-8 bg-white rounded-2xl shadow-nebulaui">
            <div class="w-16 h-16 mx-auto mb-4 bg-primary/10 rounded-full flex items-center justify-center">
                <svg class="w-8 h-8 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path>
                </svg>
            </div>
            <h3 class="text-lg font-medium text-gray-700 mb-2"><?php _e('暂无评论'); ?></h3>
            <p class="text-gray-500 mb-4"><?php _e('成为第一个评论的人吧！'); ?></p>
        </div>
    <?php endif; ?>

    <?php if ($this->allow('comment')): ?>
        <div id="<?php $this->respondId(); ?>" class="respond mt-8 bg-white rounded-2xl shadow-nebulaui p-6">
            <div class="cancel-comment-reply mb-4 hidden">
                <?php $comments->cancelReply(); ?>
            </div>

            <h3 id="response" class="text-xl font-bold text-gray-800 mb-6">
                <?php _e('发表评论'); ?>
            </h3>
            
            <form method="post" action="<?php $this->commentUrl() ?>" id="comment-form" class="space-y-4" role="form">
                <?php $comments->securityToken(); ?>
                
                <?php if ($this->user->hasLogin()): ?>
                    <div class="bg-blue-50 border border-blue-200 rounded-lg p-3 mb-4">
                        <p class="text-sm text-blue-800">
                            <?php _e('登录身份: '); ?>
                            <a href="<?php echo htmlspecialchars($this->options->profileUrl(), ENT_QUOTES, 'UTF-8'); ?>" class="font-medium text-primary hover:underline">
                                <?php echo htmlspecialchars($this->user->screenName(), ENT_QUOTES, 'UTF-8'); ?>
                            </a>。
                            <a href="<?php echo htmlspecialchars($this->options->logoutUrl(), ENT_QUOTES, 'UTF-8'); ?>" class="text-primary hover:underline">
                                <?php _e('退出'); ?> &raquo;
                            </a>
                        </p>
                    </div>
                <?php else: ?>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label for="author" class="block text-sm font-medium text-gray-700 mb-1 required">
                                <?php _e('称呼'); ?>
                            </label>
                            <input type="text" name="author" id="author" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent"
                                   value="<?php echo htmlspecialchars($this->remember('author'), ENT_QUOTES, 'UTF-8'); ?>" 
                                   pattern="[^<>]*"
                                   title="不能包含<和>字符"
                                   required />
                        </div>
                        <div>
                            <label for="mail" class="block text-sm font-medium text-gray-700 mb-1 <?php if ($this->options->commentsRequireMail): ?>required<?php endif; ?>">
                                <?php _e('Email'); ?>
                            </label>
                            <input type="email" name="mail" id="mail" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent"
                                   value="<?php echo htmlspecialchars($this->remember('mail'), ENT_QUOTES, 'UTF-8'); ?>" 
                                   <?php if ($this->options->commentsRequireMail): ?> required<?php endif; ?>
                                   pattern="[^<>]*"
                                   title="不能包含<和>字符" />
                        </div>
                    </div>
                    <div>
                        <label for="url" class="block text-sm font-medium text-gray-700 mb-1 <?php if ($this->options->commentsRequireURL): ?>required<?php endif; ?>">
                            <?php _e('网站'); ?>
                        </label>
                        <input type="url" name="url" id="url" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent"
                               placeholder="<?php _e('http://'); ?>"
                               value="<?php echo htmlspecialchars($this->remember('url'), ENT_QUOTES, 'UTF-8'); ?>" 
                               <?php if ($this->options->commentsRequireURL): ?> required<?php endif; ?>
                               pattern="[^<>]*"
                               title="不能包含<和>字符" />
                    </div>
                <?php endif; ?>
                
                <div>
                    <label for="textarea" class="block text-sm font-medium text-gray-700 mb-1 required">
                        <?php _e('内容'); ?>
                    </label>
                    <textarea name="text" id="textarea" rows="5" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent"
                              required
                              pattern="[^<>]*"
                              title="不能包含<和>字符"><?php echo htmlspecialchars($this->remember('text'), ENT_QUOTES, 'UTF-8'); ?></textarea>                  
                </div>
                
                <div id="avatar-preview" class="hidden flex items-center space-x-4 p-3 bg-gray-50 rounded-lg">
                    <div class="text-sm text-gray-600">您的头像预览：</div>
                    <img id="preview-avatar" src="" alt="头像预览" class="w-8 h-8 rounded-full">
                    <div class="text-xs text-gray-500">基于您的邮箱自动生成</div>
                </div>
                
                <div class="flex items-center justify-between pt-2">
                    <button type="submit" class="bg-primary hover:bg-primary/90 text-white px-6 py-2.5 rounded-lg transition-colors duration-300 font-medium inline-flex items-center">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"></path>
                        </svg>
                        <?php _e('提交评论'); ?>
                    </button>                    
                </div>
            </form>
        </div>
    <?php else: ?>
        <div class="bg-gray-50 border border-gray-200 rounded-lg p-6 text-center mt-8">
            <h3 class="text-lg font-medium text-gray-700 mb-2"><?php _e('评论已关闭'); ?></h3>
            <p class="text-gray-500"><?php _e('本文评论功能已关闭'); ?></p>
        </div>
    <?php endif; ?>
</div>