<?php
if (!defined('__TYPECHO_ROOT_DIR__')) {
	http_response_code(404);
	exit;
}
$this->need('header.php');
?>

<header class="py-12 md:py-16 px-4 bg-gradient-to-b from-white to-gray-50 border-b border-gray-200">
    <div class="max-w-4xl mx-auto text-center">
        <h1 class="text-3xl md:text-4xl font-bold text-dark mb-4">
            <i class="fa fa-tags text-primary mr-2"></i> 所有标签
        </h1>
        <p class="text-gray-600">探索所有文章标签</p>
    </div>
</header>

<main class="max-w-7xl mx-auto px-4 py-8">
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        <div class="lg:col-span-2">
            <div class="bg-white rounded-2xl shadow-nebulaui p-6 md:p-8">
                <div class="mb-6">
                    <h2 class="text-xl font-bold text-dark mb-2">标签云</h2>
                    <p class="text-gray-500 text-sm">仅展示所有标签</p>
                </div>
                
                <div class="flex flex-wrap gap-3">
                    <?php
                    $tags = Typecho_Widget::widget('Widget_Metas_Tag_Cloud');
                    if ($tags->have()):
                        while ($tags->next()):
                            $count = $tags->count;
                            $sizeClass = 'text-sm';
                            if ($count >= 50) $sizeClass = 'text-xl';
                            elseif ($count >= 20) $sizeClass = 'text-lg';
                            elseif ($count >= 10) $sizeClass = 'text-base';
                            $colors = array(
                                'bg-blue-100 text-blue-800',
                                'bg-purple-100 text-purple-800',
                                'bg-green-100 text-green-800',
                                'bg-yellow-100 text-yellow-800',
                                'bg-red-100 text-red-800',
                                'bg-indigo-100 text-indigo-800',
                            );
                            $color = $colors[array_rand($colors)];
                    ?>
                    <div class="px-4 py-2 rounded-full <?php echo $sizeClass . ' ' . $color; ?>">
                        <?php echo $tags->name; ?>
                        <span class="text-xs ml-1 bg-white/30 px-1 rounded-full"><?php echo $count; ?></span>
                    </div>
                    <?php 
                        endwhile;
                    else: 
                    ?>
                    <div class="text-center py-8 w-full">
                        <i class="fa fa-tag text-4xl text-gray-300 mb-3"></i>
                        <p class="text-gray-500">暂无标签</p>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <div class="lg:col-span-1">
            <div class="bg-white rounded-2xl shadow-nebulaui p-6 mb-6">
                <h3 class="text-lg font-semibold mb-4">标签统计</h3>
                <div class="space-y-4">
                    <div class="flex items-center justify-between">
                        <span class="text-gray-600">总标签数</span>
                        <span class="text-xl font-bold text-primary">
                            <?php
                            $db = Typecho_Db::get();
                            $total = $db->fetchRow($db->select('COUNT(*) as total')
                                ->from('table.metas')
                                ->where('type = ?', 'tag'));
                            echo $total['total'] ?? 0;
                            ?>
                        </span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-gray-600">总文章数</span>
                        <span class="text-xl font-bold text-primary">
                            <?php
                            $posts = $db->fetchRow($db->select('COUNT(*) as total')
                                ->from('table.contents')
                                ->where('type = ?', 'post')
                                ->where('status = ?', 'publish'));
                            echo $posts['total'] ?? 0;
                            ?>
                        </span>
                    </div>
                </div>
            </div>
            
            <div class="bg-white rounded-2xl shadow-nebulaui p-6">
                <h3 class="text-lg font-semibold mb-4">热门标签</h3>
                <div class="space-y-3">
                    <?php
                    $hotTags = Typecho_Widget::widget('Widget_Metas_Tag_Cloud', 'sort=count&desc=1&limit=10');
                    $index = 1;
                    while ($hotTags->next()):
                    ?>
                    <div class="flex items-center justify-between p-3 rounded-lg">
                        <div class="flex items-center">
                            <span class="w-8 h-8 flex items-center justify-center bg-gray-100 text-gray-600 rounded-full text-sm mr-3">
                                <?php echo $index; ?>
                            </span>
                            <span class="text-gray-700 font-medium"><?php echo $hotTags->name; ?></span>
                        </div>
                        <span class="text-xs bg-primary/10 text-primary px-2 py-1 rounded-full"><?php echo $hotTags->count; ?>篇</span>
                    </div>
                    <?php 
                        $index++;
                    endwhile; 
                    ?>
                </div>
            </div>
        </div>
    </div>
</main>

<?php $this->need('footer.php'); ?>